/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class NoiseReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final Codec<NoiseReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("output_block").forGetter(config -> config.outputBlock), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("threshold").forGetter(config -> Float.valueOf(config.threshold)), (App)Codec.FLOAT.fieldOf("xz_scale").forGetter(config -> Float.valueOf(config.xzScale)), (App)Codec.FLOAT.fieldOf("y_scale").forGetter(config -> Float.valueOf(config.yScale))).apply((Applicative)instance, instance.stable(NoiseReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Block outputBlock;
    private final float threshold;
    private final float xzScale;
    private final float yScale;
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public NoiseReplaceWithPropertiesProcessor(Block inputBlock, Block outputBlock, float threshold, float xzScale, float yScale) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.threshold = threshold;
        this.xzScale = xzScale;
        this.yScale = yScale;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        BlockPos worldPos;
        double noiseVal;
        this.setSeed(worldReader instanceof WorldGenRegion ? ((WorldGenRegion)worldReader).m_7328_() : 0L);
        if (infoIn2.f_74676_.m_60734_() == this.inputBlock && (noiseVal = this.noiseGenerator.noise3_Classic((float)(worldPos = infoIn2.f_74675_).m_123341_() * this.xzScale, (float)worldPos.m_123342_() * this.yScale, (float)worldPos.m_123343_() * this.xzScale)) / 2.0 + 0.5 < (double)this.threshold) {
            BlockState newBlockState = this.outputBlock.m_49966_();
            for (Property property : infoIn2.f_74676_.m_61147_()) {
                if (!newBlockState.m_61138_(property)) continue;
                newBlockState = this.getStateWithProperty(newBlockState, infoIn2.f_74676_, property);
            }
            return new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, newBlockState, infoIn2.f_74677_);
        }
        return infoIn2;
    }

    private <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.m_61124_(property, stateToCopy.m_61143_(property));
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)BzProcessors.NOISE_REPLACE_WITH_PROPERTIES_PROCESSOR.get();
    }
}

