/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzStructures;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.structures.OptimizedJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class GenericOptimizedStructure
extends Structure {
    public static final Codec<GenericOptimizedStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericOptimizedStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius)).apply((Applicative)instance, GenericOptimizedStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    public final Optional<Integer> biomeRadius;

    public GenericOptimizedStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> biomeRadius) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.biomeRadius = biomeRadius;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int y = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos centerPos = new BlockPos(chunkpos.m_45604_(), y, chunkpos.m_45605_());
        if (this.biomeRadius.isPresent() && !(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            int sectionY = centerPos.m_123342_();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += GeneralUtils.getLowestLand(context.f_226622_(), context.f_226624_(), new BoundingBox(0, 0, 0, 1, 1, 1), context.f_226629_(), true, this.projectStartToHeightmap.get() == Heightmap.Types.OCEAN_FLOOR_WG).m_123342_();
            }
            sectionY = QuartPos.m_175400_((int)sectionY);
            for (int curChunkX = chunkpos.f_45578_ - validBiomeRange; curChunkX <= chunkpos.f_45578_ + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkpos.f_45579_ - validBiomeRange; curChunkZ <= chunkpos.f_45579_ + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), sectionY, QuartPos.m_175404_((int)curChunkZ), context.f_226624_().m_224579_());
                    if (context.f_226630_().test(biome)) continue;
                    return Optional.empty();
                }
            }
        }
        return OptimizedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.f_226621_().m_175515_(Registries.f_256944_).m_7981_((Object)this), centerPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(centerPos, pieces));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BzStructures.GENERIC_OPTIMIZED_STRUCTURE.get();
    }
}

