/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningAltarTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.InfusionAltarTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class GuiOverlayHandler {
    private static final IGuiOverlay ALTAR_OVERLAY = (gui, matrix, partialTicks, width, height) -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        HitResult patt1655$temp = mc.f_91077_;
        if (patt1655$temp instanceof BlockHitResult) {
            BaseInventoryTileEntity altar;
            ISpecialRecipe recipe;
            BlockHitResult result = (BlockHitResult)patt1655$temp;
            BlockPos pos = result.m_82425_();
            BlockEntity tile = mc.f_91073_.m_7702_(pos);
            ItemStack stack = ItemStack.f_41583_;
            if (tile instanceof InfusionAltarTileEntity && (recipe = (altar = (InfusionAltarTileEntity)tile).getActiveRecipe()) != null) {
                stack = recipe.m_8043_();
            }
            if (tile instanceof AwakeningAltarTileEntity && (recipe = (altar = (AwakeningAltarTileEntity)tile).getActiveRecipe()) != null) {
                stack = recipe.m_8043_();
                GuiOverlayHandler.drawEssenceRequirements(matrix, (AwakeningRecipe)recipe, (AwakeningAltarTileEntity)altar);
            }
            if (!stack.m_41619_()) {
                int x = mc.m_91268_().m_85445_() / 2 - 11;
                int y = mc.m_91268_().m_85446_() / 2 - 8;
                mc.m_91291_().m_115203_(stack, x + 26, y);
                mc.m_91291_().m_115169_(mc.f_91062_, stack, x + 26, y);
                mc.f_91062_.m_92763_(matrix, stack.m_41786_(), (float)(x + 48), (float)(y + 5), 0xF9FFFE);
            }
        }
    };
    private static final IGuiOverlay ESSENCE_VESSEL_OVERLAY = (gui, matrix, partialTicks, width, height) -> {
        EssenceVesselTileEntity vessel;
        ItemStack stack;
        BlockHitResult result;
        BlockPos pos;
        BlockEntity tile;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        HitResult patt3117$temp = mc.f_91077_;
        if (patt3117$temp instanceof BlockHitResult && (tile = mc.f_91073_.m_7702_(pos = (result = (BlockHitResult)patt3117$temp).m_82425_())) instanceof EssenceVesselTileEntity && !(stack = (vessel = (EssenceVesselTileEntity)tile).getInventory().getStackInSlot(0)).m_41619_()) {
            int x = mc.m_91268_().m_85445_() / 2 - 11;
            int y = mc.m_91268_().m_85446_() / 2 - 8;
            mc.m_91291_().m_115203_(stack, x + 26, y);
            mc.m_91291_().m_115169_(mc.f_91062_, stack, x + 26, y);
            mc.f_91062_.m_92763_(matrix, stack.m_41786_(), (float)(x + 48), (float)(y + 5), 0xF9FFFE);
        }
    };

    @SubscribeEvent
    public void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "altar_overlay", ALTAR_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "essence_vessel_overlay", ESSENCE_VESSEL_OVERLAY);
    }

    private static void drawEssenceRequirements(PoseStack matrix, AwakeningRecipe recipe, AwakeningAltarTileEntity altar) {
        Minecraft mc = Minecraft.m_91087_();
        int x = mc.m_91268_().m_85445_() / 2 - 11;
        int y = mc.m_91268_().m_85446_() / 2 - 4;
        Objects.requireNonNull(mc.f_91062_);
        int lineHeight = 9 + 6;
        IAwakeningRecipe.EssenceVesselRequirements requirements = recipe.getEssenceRequirements();
        List<EssenceVesselTileEntity> vessels = altar.getEssenceVessels();
        boolean hasMissingEssences = false;
        int xOffset = 0;
        for (EssenceVesselTileEntity vessel : vessels) {
            ItemStack stack = vessel.getInventory().getStackInSlot(0);
            if (stack.m_150930_(ModCrops.AIR.getEssenceItem()) && stack.m_41613_() < requirements.air()) {
                mc.m_91291_().m_115203_(stack, x + 26 + xOffset, y + 2 * lineHeight);
                mc.f_91062_.m_92750_(matrix, GuiOverlayHandler.getEssenceDisplayName(stack, requirements.air()), (float)(x + 48 + xOffset), (float)(y + 5 + 2 * lineHeight), 0xF9FFFE);
                xOffset += 56;
                hasMissingEssences = true;
            }
            if (stack.m_150930_(ModCrops.EARTH.getEssenceItem()) && stack.m_41613_() < requirements.earth()) {
                mc.m_91291_().m_115203_(stack, x + 26 + xOffset, y + 2 * lineHeight);
                mc.f_91062_.m_92750_(matrix, GuiOverlayHandler.getEssenceDisplayName(stack, requirements.earth()), (float)(x + 48 + xOffset), (float)(y + 5 + 2 * lineHeight), 0xF9FFFE);
                xOffset += 56;
                hasMissingEssences = true;
            }
            if (stack.m_150930_(ModCrops.WATER.getEssenceItem()) && stack.m_41613_() < requirements.water()) {
                mc.m_91291_().m_115203_(stack, x + 26 + xOffset, y + 2 * lineHeight);
                mc.f_91062_.m_92750_(matrix, GuiOverlayHandler.getEssenceDisplayName(stack, requirements.water()), (float)(x + 48 + xOffset), (float)(y + 5 + 2 * lineHeight), 0xF9FFFE);
                xOffset += 56;
                hasMissingEssences = true;
            }
            if (!stack.m_150930_(ModCrops.FIRE.getEssenceItem()) || stack.m_41613_() >= requirements.fire()) continue;
            mc.m_91291_().m_115203_(stack, x + 26 + xOffset, y + 2 * lineHeight);
            mc.f_91062_.m_92750_(matrix, GuiOverlayHandler.getEssenceDisplayName(stack, requirements.fire()), (float)(x + 48 + xOffset), (float)(y + 5 + 2 * lineHeight), 0xF9FFFE);
            xOffset += 56;
            hasMissingEssences = true;
        }
        if (hasMissingEssences) {
            mc.f_91062_.m_92750_(matrix, ModTooltips.MISSING_ESSENCES.buildString(), (float)(x + 28), (float)(y + 5 + lineHeight), 0xF9FFFE);
        }
    }

    private static String getEssenceDisplayName(ItemStack stack, int required) {
        return stack.m_41613_() + "/" + required;
    }
}

