/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.mysticalagriculture.container.SoulExtractorContainer;
import com.blakebr0.mysticalagriculture.tileentity.SoulExtractorTileEntity;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class SoulExtractorScreen
extends BaseContainerScreen<SoulExtractorContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("mysticalagriculture", "textures/gui/soul_extractor.png");
    private SoulExtractorTileEntity tile;

    public SoulExtractorScreen(SoulExtractorContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title, BACKGROUND, 176, 194);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.m_142416_((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy(), (AbstractContainerScreen)this));
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        this.f_96547_.m_92883_(stack, title, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        if (this.tile != null) {
            MachineUpgradeTier tier = this.tile.getMachineTier();
            DynamicEnergyStorage energy = this.tile.getEnergy();
            energy.resetMaxEnergyStorage();
            if (tier != null) {
                energy.setMaxEnergyStorage((int)((double)this.tile.getEnergy().getMaxEnergyStored() * tier.getFuelCapacityMultiplier()));
            }
        }
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        this.renderDefaultBg(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.getFuelItemValue() > 0) {
            int lol = this.getBurnLeftScaled(13);
            this.m_93228_(stack, x + 31, y + 52 - lol, 176, 12 - lol, 14, lol + 1);
        }
        if (this.getProgress() > 0) {
            int i2 = this.getProgressScaled(24);
            this.m_93228_(stack, x + 98, y + 51, 176, 14, i2 + 1, 16);
        }
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_7025_(stack, mouseX, mouseY);
        if (mouseX > x + 30 && mouseX < x + 45 && mouseY > y + 39 && mouseY < y + 53) {
            MutableComponent text = Component.m_237113_((String)(SoulExtractorScreen.number((Object)this.getFuelLeft()) + " FE"));
            this.m_96602_(stack, (Component)text, mouseX, mouseY);
        }
    }

    private SoulExtractorTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((SoulExtractorContainer)this.m_6262_()).getBlockPos())) instanceof SoulExtractorTileEntity) {
            SoulExtractorTileEntity extractor = (SoulExtractorTileEntity)tile;
            return extractor;
        }
        return null;
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getOperationTime() {
        if (this.tile == null) {
            return 0;
        }
        MachineUpgradeTier tier = this.tile.getMachineTier();
        if (tier == null) {
            return this.tile.getOperationTime();
        }
        return (int)((double)this.tile.getOperationTime() * tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelLeft();
    }

    public int getFuelItemValue() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelItemValue();
    }

    public int getProgressScaled(int pixels) {
        int i = this.getProgress();
        int j = this.getOperationTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.getFuelLeft();
        int j = this.getFuelItemValue();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

