/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.event.RegisterRecipesEvent;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DynamicRecipeManager {
    private static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRegisterRecipes(RegisterRecipesEvent event) {
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            ISpecialRecipe seed = DynamicRecipeManager.makeSeedRecipe(crop);
            Recipe<?> seedRegular = DynamicRecipeManager.makeRegularSeedRecipe(crop);
            ISpecialRecipe reprocessor = DynamicRecipeManager.makeReprocessorRecipe(crop);
            if (seed != null) {
                event.register((Recipe)seed);
            }
            if (seedRegular != null) {
                event.register(seedRegular);
            }
            if (reprocessor == null) continue;
            event.register((Recipe)reprocessor);
        }
    }

    public static DynamicRecipeManager getInstance() {
        return INSTANCE;
    }

    private static ISpecialRecipe makeSeedRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedInfusionRecipeEnabled()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient essence = Ingredient.m_43929_((ItemLike[])new ItemLike[]{essenceItem});
        Ingredient craftingSeed = Ingredient.m_43929_((ItemLike[])new ItemLike[]{craftingSeedItem});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{craftingSeed, material, essence, material, essence, material, essence, material, essence});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_infusion"));
        ItemStack output = new ItemStack((ItemLike)crop.getSeedsItem());
        return new InfusionRecipe(name, (NonNullList<Ingredient>)inputs, output);
    }

    private static Recipe<?> makeRegularSeedRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedCraftingRecipeEnabled()) {
            return null;
        }
        if (!((Boolean)ModConfigs.SEED_CRAFTING_RECIPES.get()).booleanValue()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient essence = Ingredient.m_43929_((ItemLike[])new ItemLike[]{essenceItem});
        Ingredient craftingSeed = Ingredient.m_43929_((ItemLike[])new ItemLike[]{craftingSeedItem});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, essence, material, essence, craftingSeed, essence, material, essence, material});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_vanilla"));
        ItemStack output = new ItemStack((ItemLike)crop.getSeedsItem());
        return new ShapedRecipe(name, "", CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static ISpecialRecipe makeReprocessorRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedReprocessorRecipeEnabled()) {
            return null;
        }
        Ingredient input = Ingredient.m_43929_((ItemLike[])new ItemLike[]{crop.getSeedsItem()});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_reprocessor"));
        ItemStack output = new ItemStack((ItemLike)crop.getEssenceItem(), 2);
        return new ReprocessorRecipe(name, input, output);
    }
}

