/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class AwakeningRecipe
implements ISpecialRecipe,
IAwakeningRecipe {
    public static final int RECIPE_SIZE = 9;
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final IAwakeningRecipe.EssenceVesselRequirements essences;
    private final ItemStack output;

    public AwakeningRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, IAwakeningRecipe.EssenceVesselRequirements essences, ItemStack output) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        this.essences = essences;
        this.output = output;
        this.inputs.set(0, (Object)((Ingredient)inputs.get(0)));
        this.inputs.set(1, (Object)AwakeningRecipe.createEssenceIngredient(ModCrops.AIR));
        this.inputs.set(2, (Object)((Ingredient)inputs.get(1)));
        this.inputs.set(3, (Object)AwakeningRecipe.createEssenceIngredient(ModCrops.EARTH));
        this.inputs.set(4, (Object)((Ingredient)inputs.get(2)));
        this.inputs.set(5, (Object)AwakeningRecipe.createEssenceIngredient(ModCrops.WATER));
        this.inputs.set(6, (Object)((Ingredient)inputs.get(3)));
        this.inputs.set(7, (Object)AwakeningRecipe.createEssenceIngredient(ModCrops.FIRE));
        this.inputs.set(8, (Object)((Ingredient)inputs.get(4)));
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.assemble((IItemHandler)new InvWrapper(inv));
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.AWAKENING.get();
    }

    public RecipeType<? extends IAwakeningRecipe> m_6671_() {
        return (RecipeType)ModRecipeTypes.AWAKENING.get();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack altarStack = inventory.getStackInSlot(0);
        return !this.inputs.isEmpty() && ((Ingredient)this.inputs.get(0)).test(altarStack) && super.matches(inventory);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public IAwakeningRecipe.EssenceVesselRequirements getEssenceRequirements() {
        return this.essences;
    }

    private static Ingredient createEssenceIngredient(Crop crop) {
        Item item = crop.getEssenceItem();
        return item == null ? Ingredient.f_43901_ : Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    public static class Serializer
    implements RecipeSerializer<AwakeningRecipe> {
        public AwakeningRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            JsonObject input = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)input));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i + 1, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            JsonObject essences = GsonHelper.m_13930_((JsonObject)json, (String)"essences");
            IAwakeningRecipe.EssenceVesselRequirements essenceRequirements = new IAwakeningRecipe.EssenceVesselRequirements(GsonHelper.m_13927_((JsonObject)essences, (String)"air"), GsonHelper.m_13927_((JsonObject)essences, (String)"earth"), GsonHelper.m_13927_((JsonObject)essences, (String)"water"), GsonHelper.m_13927_((JsonObject)essences, (String)"fire"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            return new AwakeningRecipe(recipeId, (NonNullList<Ingredient>)inputs, essenceRequirements, result);
        }

        public AwakeningRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            IAwakeningRecipe.EssenceVesselRequirements essences = new IAwakeningRecipe.EssenceVesselRequirements(buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_());
            ItemStack output = buffer.m_130267_();
            return new AwakeningRecipe(recipeId, (NonNullList<Ingredient>)inputs, essences, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, AwakeningRecipe recipe) {
            buffer.m_130130_(5);
            for (int i = 0; i <= 8; i += 2) {
                ((Ingredient)recipe.inputs.get(i)).m_43923_(buffer);
            }
            buffer.m_130130_(recipe.essences.air());
            buffer.m_130130_(recipe.essences.earth());
            buffer.m_130130_(recipe.essences.water());
            buffer.m_130130_(recipe.essences.fire());
            buffer.m_130055_(recipe.output);
        }
    }
}

