/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.MultiblockPositions;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningPedestalTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;

public class AwakeningAltarTileEntity
extends BaseInventoryTileEntity {
    private static final MultiblockPositions PEDESTAL_LOCATIONS = new MultiblockPositions.Builder().pos(3, 0, 0).pos(2, 0, 2).pos(-3, 0, 0).pos(-2, 0, -2).pos(0, 0, 3).pos(2, 0, -2).pos(0, 0, -3).pos(-2, 0, 2).build();
    private final BaseItemStackHandler inventory = BaseItemStackHandler.create((int)2, () -> ((AwakeningAltarTileEntity)this).markDirtyAndDispatch(), handler -> {
        handler.setDefaultSlotLimit(1);
        handler.setCanInsert((slot, stack) -> handler.getStackInSlot(1).m_41619_());
        handler.setOutputSlots(new int[]{1});
    });
    private final BaseItemStackHandler recipeInventory = BaseItemStackHandler.create((int)9);
    private AwakeningRecipe recipe;
    private int progress;
    private boolean active;

    public AwakeningAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AWAKENING_ALTAR.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.active = tag.m_128471_("Active");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Active", this.active);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AwakeningAltarTileEntity tile) {
        ItemStack input = tile.inventory.getStackInSlot(0);
        if (input.m_41619_()) {
            tile.reset();
            return;
        }
        if (tile.isActive()) {
            AwakeningRecipe recipe = tile.getActiveRecipe();
            if (recipe != null && tile.hasRequiredEssences()) {
                ++tile.progress;
                List<BaseInventoryTileEntity> pedestals = tile.getPedestals();
                if (tile.progress >= 100) {
                    NonNullList remaining = recipe.getRemainingItems((IItemHandler)tile.recipeInventory);
                    for (int i = 0; i < pedestals.size(); ++i) {
                        BaseInventoryTileEntity pedestal = pedestals.get(i);
                        BaseItemStackHandler inventory = pedestal.getInventory();
                        if (pedestal instanceof EssenceVesselTileEntity) {
                            AwakeningAltarTileEntity.decrementVesselInventory(inventory, recipe.getEssenceRequirements());
                        } else {
                            inventory.setStackInSlot(0, (ItemStack)remaining.get(i + 1));
                        }
                        tile.spawnParticles(ParticleTypes.f_123762_, pedestal.m_58899_(), 1.2, 20);
                    }
                    ItemStack result = recipe.assemble((IItemHandler)tile.recipeInventory);
                    tile.setOutput(result);
                    tile.reset();
                    tile.markDirtyAndDispatch();
                    tile.spawnParticles(ParticleTypes.f_123748_, pos, 1.0, 10);
                } else {
                    for (BaseInventoryTileEntity pedestal : pedestals) {
                        BlockPos pedestalPos = pedestal.m_58899_();
                        ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                        tile.spawnItemParticles(pedestalPos, stack);
                    }
                }
            } else {
                tile.reset();
            }
        } else {
            tile.progress = 0;
        }
    }

    public List<BlockPos> getPedestalPositions() {
        return PEDESTAL_LOCATIONS.get(this.m_58899_());
    }

    public boolean isActive() {
        if (!this.active) {
            Level level = this.m_58904_();
            this.active = level != null && level.m_46753_(this.m_58899_());
        }
        return this.active;
    }

    public void setActive() {
        this.active = true;
    }

    private void reset() {
        this.progress = 0;
        this.active = false;
    }

    public AwakeningRecipe getActiveRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        this.updateRecipeInventory(this.getPedestals());
        if (this.recipe == null || !this.recipe.matches((IItemHandler)this.recipeInventory)) {
            IAwakeningRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.AWAKENING.get(), this.recipeInventory.toIInventory(), this.f_58857_).orElse(null);
            this.recipe = recipe instanceof AwakeningRecipe ? (AwakeningRecipe)recipe : null;
        }
        return this.recipe;
    }

    public List<EssenceVesselTileEntity> getEssenceVessels() {
        return this.getPedestals().stream().filter(p -> p instanceof EssenceVesselTileEntity).map(p -> (EssenceVesselTileEntity)((Object)p)).toList();
    }

    private void updateRecipeInventory(List<BaseInventoryTileEntity> pedestals) {
        this.recipeInventory.setSize(9);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (int i = 0; i < pedestals.size(); ++i) {
            ItemStack stack = pedestals.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 1, stack);
        }
    }

    private List<BaseInventoryTileEntity> getPedestals() {
        if (this.m_58904_() == null) {
            return Collections.emptyList();
        }
        ArrayList<BaseInventoryTileEntity> pedestals = new ArrayList<BaseInventoryTileEntity>();
        for (BlockPos pos : this.getPedestalPositions()) {
            BlockEntity tile = this.m_58904_().m_7702_(pos);
            if (!(tile instanceof AwakeningPedestalTileEntity) && !(tile instanceof EssenceVesselTileEntity)) continue;
            pedestals.add((BaseInventoryTileEntity)tile);
        }
        return pedestals;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_() || stack.m_41619_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        BlockPos pos = this.m_58899_();
        double x = (double)pedestalPos.m_123341_() + level.m_213780_().m_188500_() * 0.2 + 0.4;
        double y = (double)pedestalPos.m_123342_() + level.m_213780_().m_188500_() * 0.2 + 1.2;
        double z = (double)pedestalPos.m_123343_() + level.m_213780_().m_188500_() * 0.2 + 0.4;
        double velX = pos.m_123341_() - pedestalPos.m_123341_();
        double velY = 0.25;
        double velZ = pos.m_123343_() - pedestalPos.m_123343_();
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private void setOutput(ItemStack stack) {
        this.inventory.getStacks().set(0, (Object)ItemStack.f_41583_);
        this.inventory.getStacks().set(1, (Object)stack);
    }

    private boolean hasRequiredEssences() {
        boolean hasAir = false;
        boolean hasEarth = false;
        boolean hasWater = false;
        boolean hasFire = false;
        IAwakeningRecipe.EssenceVesselRequirements requirements = this.recipe.getEssenceRequirements();
        for (int i = 1; i < this.recipeInventory.getSlots(); ++i) {
            ItemStack stack = this.recipeInventory.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof ICropProvider)) continue;
            ICropProvider provider = (ICropProvider)item;
            Crop crop = provider.getCrop();
            int count = stack.m_41613_();
            if (!hasAir && crop == ModCrops.AIR) {
                boolean bl = hasAir = count >= requirements.air();
            }
            if (!hasEarth && crop == ModCrops.EARTH) {
                boolean bl = hasEarth = count >= requirements.earth();
            }
            if (!hasWater && crop == ModCrops.WATER) {
                boolean bl = hasWater = count >= requirements.water();
            }
            if (hasFire || crop != ModCrops.FIRE) continue;
            hasFire = count >= requirements.fire();
        }
        return hasAir && hasEarth && hasWater && hasFire;
    }

    private static void decrementVesselInventory(BaseItemStackHandler inventory, IAwakeningRecipe.EssenceVesselRequirements requirements) {
        Item item = inventory.getStackInSlot(0).m_41720_();
        if (item instanceof ICropProvider) {
            ICropProvider provider = (ICropProvider)item;
            Crop crop = provider.getCrop();
            if (crop == ModCrops.AIR) {
                inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)inventory.getStackInSlot(0), (int)requirements.air(), (boolean)false));
            } else if (crop == ModCrops.EARTH) {
                inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)inventory.getStackInSlot(0), (int)requirements.earth(), (boolean)false));
            } else if (crop == ModCrops.WATER) {
                inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)inventory.getStackInSlot(0), (int)requirements.water(), (boolean)false));
            } else if (crop == ModCrops.FIRE) {
                inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)inventory.getStackInSlot(0), (int)requirements.fire(), (boolean)false));
            }
        }
    }
}

