/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.IntValue IDLE_TIME;
    public static ForgeConfigSpec.IntValue IDLE_TIME_DEVIATION;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_SOLID;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_REINFORCED;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_SOLID;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_REINFORCED;
    public static ForgeConfigSpec.IntValue BONUS_SOLID_EFFICIENCY;
    public static ForgeConfigSpec.IntValue BONUS_REINFORCED_EFFICIENCY;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> WORM_BIN_FOOD;
    public static ForgeConfigSpec.BooleanValue MISC_ENABLE_EFFICIENCY;
    public static ForgeConfigSpec.BooleanValue MISC_ENABLE_ENCHANTING;
    public static ForgeConfigSpec.IntValue MISC_BOOK_MAX_ENCHANTABILITY;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> MISC_VALID_BAIT;

    static {
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        SERVER_BUILDER.push("IdleTime");
        IDLE_TIME = SERVER_BUILDER.comment("Time (in seconds) until a strainer catches an item. [Default: 30]").defineInRange("idle_time", 30, 0, 0x6666666);
        IDLE_TIME_DEVIATION = SERVER_BUILDER.comment("Adds a deviation to the idle time to make it more random. [Default: 5]").defineInRange("idle_time_deviation", 5, 0, 0x6666666);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Set the max durability (uses) for each strainer type.\nUse 0 for infinite durability.\nDefault:\n- Normal: 120\n- Solid: 720\n- Reinforced: 8640").push("Durability");
        DURABILITY_STRAINER_SURVIVALIST = SERVER_BUILDER.defineInRange("durability_strainer_survivalist", 120, 0, 0x7FFFFFFE);
        DURABILITY_STRAINER_SURVIVALIST_SOLID = SERVER_BUILDER.defineInRange("durability_strainer_survivalist_solid", 720, 0, 0x7FFFFFFE);
        DURABILITY_STRAINER_SURVIVALIST_REINFORCED = SERVER_BUILDER.defineInRange("durability_strainer_survivalist_reinforced", 8640, 0, 0x7FFFFFFE);
        DURABILITY_STRAINER_FISHERMAN = SERVER_BUILDER.defineInRange("durability_strainer_fisherman", 120, 0, 0x7FFFFFFE);
        DURABILITY_STRAINER_FISHERMAN_SOLID = SERVER_BUILDER.defineInRange("durability_strainer_fisherman_solid", 720, 0, 0x7FFFFFFE);
        DURABILITY_STRAINER_FISHERMAN_REINFORCED = SERVER_BUILDER.defineInRange("durability_strainer_fisherman_reinforced", 8640, 0, 0x7FFFFFFE);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("Bonus");
        BONUS_SOLID_EFFICIENCY = SERVER_BUILDER.comment("Bonus efficiency (in %) for Solid Strainers. Use 0 to disable bonus efficiency. [Default: 10]").defineInRange("bonus_solid_efficiency", 10, 0, 0x7FFFFFFE);
        BONUS_REINFORCED_EFFICIENCY = SERVER_BUILDER.comment("Bonus efficiency (in %) for Reinforced Strainers. Use 0 to disable bonus efficiency. [Default: 25]").defineInRange("bonus_reinforced_efficiency", 25, 0, 0x7FFFFFFE);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("WormBin");
        WORM_BIN_FOOD = SERVER_BUILDER.comment("Valid food items for the worm bin").defineList("worm_bin_food", (List)Lists.newArrayList((Object[])new String[]{"minecraft:apple", "minecraft:potato", "minecraft:beetroot", "minecraft:melon_slice", "minecraft:sweet_berries", "minecraft:carrot", "minecraft:chorus_fruit"}), obj -> obj instanceof String);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("Misc");
        MISC_ENABLE_EFFICIENCY = SERVER_BUILDER.comment("Strainers are more or less efficient based on their placement (water level, biome, adjacent strainers).\nBonus efficiency from strainer type and enchantments still apply. [Default: true]").define("misc_enable_efficiency", true);
        MISC_ENABLE_ENCHANTING = SERVER_BUILDER.comment("Reinforced Strainers (Tier 3) can be enchanted. [Default: true]").define("misc_enable_enchanting", true);
        MISC_BOOK_MAX_ENCHANTABILITY = SERVER_BUILDER.comment("Defines the maximum 'enchantability' of Enchanted Books collected by a strainer.\nA higher value results in more powerful enchantments on the book.\nThe enchanting power will be a random number ranging from 1 to X [Default: 35]").defineInRange("misc_book_max_enchantability", 35, 1, 70);
        MISC_VALID_BAIT = SERVER_BUILDER.comment("Valid bait items for the Fisherman's Strainer").defineList("misc_valid_bait", (List)Lists.newArrayList((Object[])new String[]{"waterstrainer:worm", "waterstrainer:super_worm", "aquaculture:worm"}), obj -> obj instanceof String);
        SERVER_BUILDER.pop();
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

