/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei.gardentrowel;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.waterstrainer.integration.jei.WaterStrainerPlugin;
import mods.waterstrainer.integration.jei.gardentrowel.GardenTrowelRecipe;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GardenTrowelCategory
implements IRecipeCategory<GardenTrowelRecipe> {
    private final IDrawable BACKGROUND;
    private final IDrawable ICON;
    private final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_garden_trowel.png");

    public GardenTrowelCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.BACKGROUND_LOCATION, 0, 0, 170, 56);
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemRegistry.garden_trowel.get()));
    }

    public RecipeType<GardenTrowelRecipe> getRecipeType() {
        return WaterStrainerPlugin.TYPE_GARDEN_TROWEL;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Worm Drops");
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void draw(GardenTrowelRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        ItemStack input = recipe.getInput().get(1).get(0);
        int chance = Block.m_49814_((Item)input.m_41720_()) == Blocks.f_50093_ ? 50 : 25;
        String chanceStr = chance + "% Chance";
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, chanceStr, (float)(87 - minecraft.f_91062_.m_92895_(chanceStr) / 2), 5.0f, -8355712);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GardenTrowelRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 20).addItemStacks(recipe.getInput().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 20).addItemStacks(recipe.getInput().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 20).addItemStacks(recipe.getOutput().get(0));
    }
}

