/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei.strainer;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.waterstrainer.integration.jei.WaterStrainerPlugin;
import mods.waterstrainer.integration.jei.strainer.StrainerRecipe;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class StrainerCategory
implements IRecipeCategory<StrainerRecipe> {
    private final IDrawable BACKGROUND;
    private final IDrawable ICON;
    private final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_strainer.png");

    public StrainerCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.BACKGROUND_LOCATION, 0, 0, 92, 122);
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemRegistry.strainer_survivalist.get()));
    }

    public RecipeType<StrainerRecipe> getRecipeType() {
        return WaterStrainerPlugin.TYPE_STRAINER;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Straining");
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StrainerRecipe recipe, IFocusGroup focuses) {
        int istart;
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 5).addItemStack(recipe.getInput());
        if (recipe.getOutput().isEmpty()) {
            return;
        }
        List<ItemStack> outputsTotal = recipe.getOutput().get(0);
        int icur = istart = 1;
        int imax = 25;
        ArrayList outputsPage = new ArrayList();
        while (outputsPage.size() < imax) {
            outputsPage.add(new ArrayList());
        }
        for (int index = 0; index < outputsTotal.size(); ++index) {
            ((List)outputsPage.get(index % imax)).add(outputsTotal.get(index));
        }
        for (int i = 0; i < outputsTotal.size(); ++i) {
            int column = (icur - 1) / 5;
            int row = (icur - 1) % 5;
            int x = 2 + 18 * row;
            int y = 32 + 18 * column;
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStacks((List)outputsPage.get(icur - 1));
            icur = icur >= imax ? istart : icur + 1;
        }
    }
}

