/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.item;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mods.waterstrainer.Config;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.util.LootTable;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemStrainer
extends Item {
    private static Random rand = new Random();
    public final EnumSubtype TYPE;
    public LootTable LOOT_TABLE;
    public final BlockStrainerBase.Model MODEL;

    public ItemStrainer(EnumSubtype strainerType) {
        super(new Item.Properties().m_41503_(100));
        this.TYPE = strainerType;
        this.MODEL = strainerType.model;
        this.LOOT_TABLE = new LootTable();
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)this.TYPE.configDurability.get();
    }

    public boolean isDamageable(ItemStack stack) {
        return this.m_41462_() > 0;
    }

    public boolean m_8120_(ItemStack strainer) {
        return this.TYPE.tier == StrainerTier.REINFORCED && (Boolean)Config.MISC_ENABLE_ENCHANTING.get() != false;
    }

    public int m_6473_() {
        return ArmorMaterials.IRON.m_6646_();
    }

    public boolean isBookEnchantable(ItemStack strainer, ItemStack book) {
        if (!this.m_8120_(strainer)) {
            return false;
        }
        for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)book).keySet()) {
            if (ItemStrainer.isValidEnchantment(enchantment)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack strainer, Enchantment enchantment) {
        return ItemStrainer.isValidEnchantment(enchantment);
    }

    public static boolean isValidEnchantment(Enchantment enchantment) {
        return (Boolean)Config.MISC_ENABLE_ENCHANTING.get() != false && (enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44953_);
    }

    public int getEnchantmentLevel(ItemStack strainer, Enchantment enchantment) {
        return (Boolean)Config.MISC_ENABLE_ENCHANTING.get() != false ? super.getEnchantmentLevel(strainer, enchantment) : 0;
    }

    public static boolean generateBonusItem(int level) {
        return level >= rand.nextInt(3) + 1;
    }

    public static boolean preventDamage(int level) {
        return level >= rand.nextInt(10) + 1;
    }

    public void m_7373_(ItemStack stack, @Nullable Level player, List<Component> tooltip, TooltipFlag advanced) {
        if (stack.m_41763_()) {
            int uses = stack.m_41776_() - stack.m_41773_();
            String left = uses <= 1 ? "#GREEN#1 use left" : String.format("#GREEN#%s uses left", uses);
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(left));
        } else {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("#GREEN#Does not break"));
        }
        if (this.TYPE.tier == StrainerTier.SOLID) {
            if ((Integer)Config.BONUS_SOLID_EFFICIENCY.get() > 0) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(String.format("#GREEN#+%s%% Efficiency", Config.BONUS_SOLID_EFFICIENCY.get())));
            }
        } else if (this.TYPE.tier == StrainerTier.REINFORCED) {
            if ((Integer)Config.BONUS_REINFORCED_EFFICIENCY.get() > 0) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(String.format("#GREEN#+%s%% Efficiency", Config.BONUS_REINFORCED_EFFICIENCY.get())));
            }
            if (((Boolean)Config.MISC_ENABLE_ENCHANTING.get()).booleanValue()) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("#GREEN#+Enchantable"));
            }
        }
        if (this.TYPE.category == StrainerCategory.FISHER) {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Catches fish, junk and treasures.", "Requires Bait."));
        } else if (this.TYPE.category == StrainerCategory.SURVIVAL) {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Collects general items."));
        }
        WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Requires a Strainer Base."));
        if (this.LOOT_TABLE.items.size() == 0) {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("#RED#This strainer has no valid output items configured and is therefore useless."));
        }
    }

    public int getEfficiencyBonus() {
        if (this.TYPE.tier == StrainerTier.SOLID && (Integer)Config.BONUS_SOLID_EFFICIENCY.get() > 0) {
            return (Integer)Config.BONUS_SOLID_EFFICIENCY.get();
        }
        if (this.TYPE.tier == StrainerTier.REINFORCED && (Integer)Config.BONUS_REINFORCED_EFFICIENCY.get() > 0) {
            return (Integer)Config.BONUS_REINFORCED_EFFICIENCY.get();
        }
        return 0;
    }

    public static enum EnumSubtype {
        STRAINER_SURVIVALIST("strainer_survivalist", StrainerCategory.SURVIVAL, StrainerTier.NORMAL, BlockStrainerBase.Model.STRAINER_SURVIVALIST, Config.DURABILITY_STRAINER_SURVIVALIST),
        STRAINER_SURVIVALIST_SOLID("strainer_survivalist_solid", StrainerCategory.SURVIVAL, StrainerTier.SOLID, BlockStrainerBase.Model.STRAINER_SURVIVALIST_SOLID, Config.DURABILITY_STRAINER_SURVIVALIST_SOLID),
        STRAINER_SURVIVALIST_REINFORCED("strainer_survivalist_reinforced", StrainerCategory.SURVIVAL, StrainerTier.REINFORCED, BlockStrainerBase.Model.STRAINER_SURVIVALIST_REINFORCED, Config.DURABILITY_STRAINER_SURVIVALIST_REINFORCED),
        STRAINER_FISHERMAN("strainer_fisherman", StrainerCategory.FISHER, StrainerTier.NORMAL, BlockStrainerBase.Model.STRAINER_FISHERMAN, Config.DURABILITY_STRAINER_FISHERMAN),
        STRAINER_FISHERMAN_SOLID("strainer_fisherman_solid", StrainerCategory.FISHER, StrainerTier.SOLID, BlockStrainerBase.Model.STRAINER_FISHERMAN_SOLID, Config.DURABILITY_STRAINER_FISHERMAN_SOLID),
        STRAINER_FISHERMAN_REINFORCED("strainer_fisherman_reinforced", StrainerCategory.FISHER, StrainerTier.REINFORCED, BlockStrainerBase.Model.STRAINER_FISHERMAN_REINFORCED, Config.DURABILITY_STRAINER_FISHERMAN_REINFORCED);

        public final BlockStrainerBase.Model model;
        public final StrainerCategory category;
        public final StrainerTier tier;
        public final String regname;
        public final ForgeConfigSpec.IntValue configDurability;

        private EnumSubtype(String name, StrainerCategory cat, StrainerTier tier, BlockStrainerBase.Model model, ForgeConfigSpec.IntValue configDurability) {
            this.regname = name;
            this.model = model;
            this.category = cat;
            this.tier = tier;
            this.configDurability = configDurability;
        }

        public static EnumSubtype getSubtype(ItemStack stack) {
            Item item = stack.m_41720_();
            return item instanceof ItemStrainer ? ((ItemStrainer)item).TYPE : STRAINER_SURVIVALIST;
        }
    }

    public static enum StrainerTier {
        NORMAL,
        SOLID,
        REINFORCED;

    }

    public static enum StrainerCategory {
        SURVIVAL,
        FISHER;

    }
}

