/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemEfficiencyMeter;
import mods.waterstrainer.item.ItemFertilizer;
import mods.waterstrainer.item.ItemGardenTrowel;
import mods.waterstrainer.item.ItemMesh;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.item.ItemSuperWorm;
import mods.waterstrainer.item.ItemWorm;
import mods.waterstrainer.registry.BlockRegistry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waterstrainer");
    public static final RegistryObject<Item> strainer_base = ITEMS.register("strainer_base", () -> new BlockItem((Block)BlockRegistry.strainer_base.get(), new Item.Properties()));
    public static final RegistryObject<Item> worm_bin = ITEMS.register("worm_bin", () -> new BlockItem((Block)BlockRegistry.worm_bin.get(), new Item.Properties()));
    public static final RegistryObject<Item> strainer_survivalist = ITEMS.register(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST.regname, () -> ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST)));
    public static final RegistryObject<Item> strainer_survivalist_solid = ITEMS.register(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST_SOLID.regname, () -> ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST_SOLID)));
    public static final RegistryObject<Item> strainer_survivalist_reinforced = ITEMS.register(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST_REINFORCED.regname, () -> ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST_REINFORCED)));
    public static final RegistryObject<Item> strainer_fisherman = ITEMS.register(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN.regname, () -> ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN)));
    public static final RegistryObject<Item> strainer_fisherman_solid = ITEMS.register(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN_SOLID.regname, () -> ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN_SOLID)));
    public static final RegistryObject<Item> strainer_fisherman_reinforced = ITEMS.register(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN_REINFORCED.regname, () -> ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN_REINFORCED)));
    public static final RegistryObject<Item> string_mesh = ITEMS.register("string_mesh", () -> new ItemMesh(ItemMesh.EnumSubtype.STRING_MESH));
    public static final RegistryObject<Item> iron_mesh = ITEMS.register("iron_mesh", () -> new ItemMesh(ItemMesh.EnumSubtype.IRON_MESH));
    public static final RegistryObject<Item> obsidian_mesh = ITEMS.register("obsidian_mesh", () -> new ItemMesh(ItemMesh.EnumSubtype.OBSIDIAN_MESH));
    public static final RegistryObject<Item> worm = ITEMS.register("worm", () -> new ItemWorm());
    public static final RegistryObject<Item> super_worm = ITEMS.register("super_worm", () -> new ItemSuperWorm());
    public static final RegistryObject<Item> bait_pot = ITEMS.register("bait_pot", () -> new ItemBaitPot());
    public static final RegistryObject<Item> garden_trowel = ITEMS.register("garden_trowel", () -> new ItemGardenTrowel());
    public static final RegistryObject<Item> efficiency_meter = ITEMS.register("efficiency_meter", () -> new ItemEfficiencyMeter());
    public static final RegistryObject<Item> fertilizer = ITEMS.register("fertilizer", () -> new ItemFertilizer());
    public static List<ItemStrainer> strainers = new ArrayList<ItemStrainer>();

    public static void register(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
    }

    public static ItemStrainer addStrainer(ItemStrainer strainer) {
        strainers.add(strainer);
        return strainer;
    }

    public static ItemStrainer getStrainer(String registryName) {
        for (ItemStrainer strainer : strainers) {
            if (!Objects.equals(strainer.TYPE.regname, registryName)) continue;
            return strainer;
        }
        return null;
    }

    public static List<ItemStrainer> getStrainerList(ItemStrainer.StrainerTier tier) {
        ArrayList<ItemStrainer> list = new ArrayList<ItemStrainer>();
        for (ItemStrainer strainer : strainers) {
            if (strainer.TYPE.tier != tier) continue;
            list.add(strainer);
        }
        return list;
    }
}

