/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.tileentity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.waterstrainer.Config;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.item.ItemSuperWorm;
import mods.waterstrainer.registry.TileEntityRegistry;
import mods.waterstrainer.util.EfficiencyData;
import mods.waterstrainer.util.LootTable;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityStrainer
extends BlockEntity
implements MenuProvider {
    private final VoxelShape SHAPE_SUCK_ITEMS = Block.m_49796_((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public InventoryHandler inv = this.initInventory();
    private int curIdleTime = 0;
    private int maxIdleTime = (Integer)Config.IDLE_TIME.get() * 20;
    private static Random rand = new Random();
    private final ContainerData syncValues = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntityStrainer.this.curIdleTime;
                }
                case 1: {
                    return TileEntityStrainer.this.maxIdleTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityStrainer.this.curIdleTime = value;
                    break;
                }
                case 1: {
                    TileEntityStrainer.this.maxIdleTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private final LazyOptional<IItemHandler> capItemHandler = LazyOptional.of(() -> this.createCapabilityHandler());

    public TileEntityStrainer(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistry.tile_strainer_base.get(), pos, state);
    }

    private InventoryHandler initInventory() {
        return new InventoryHandler(this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inv = this.initInventory();
        this.inv.deserializeNBT(nbt);
        this.curIdleTime = nbt.m_128451_("CurIdleTime");
        this.maxIdleTime = nbt.m_128451_("MaxIdleTime");
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128391_(this.inv.serializeNBT());
        nbt.m_128405_("CurIdleTime", this.curIdleTime);
        nbt.m_128405_("MaxIdleTime", this.maxIdleTime);
    }

    protected IItemHandler createCapabilityHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inv}){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return (slot < 1 || slot > 27) && this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot >= 1 && slot <= 27 ? super.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
            }
        };
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.capItemHandler);
    }

    public ItemStack getStrainer() {
        return this.inv.getStackInSlot(0);
    }

    public void serverTick() {
        ++this.curIdleTime;
        if (this.f_58857_.m_46467_() % 20L == 10L) {
            List items;
            if (this.getStrainer().m_41619_()) {
                this.curIdleTime = 0;
            }
            if ((items = this.SHAPE_SUCK_ITEMS.m_83299_().stream().flatMap(aabb -> this.m_58904_().m_6443_(ItemEntity.class, aabb.m_82386_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), EntitySelector.f_20402_).stream()).collect(Collectors.toList())).size() > 0) {
                WaterStrainerUtils.addEntityItemToInventory((ItemEntity)items.get(0), this.inv, 1, 27);
                this.m_6596_();
            }
        }
        if (this.curIdleTime >= this.maxIdleTime) {
            this.curIdleTime = 0;
            int min = (Integer)Config.IDLE_TIME.get() - (Integer)Config.IDLE_TIME_DEVIATION.get();
            int max = (Integer)Config.IDLE_TIME.get() + (Integer)Config.IDLE_TIME_DEVIATION.get();
            this.maxIdleTime = (rand.nextInt(max - min + 1) + min) * 20;
            float efficiency = new EfficiencyData(this).getTotalEfficiency();
            if (efficiency > 0.0f) {
                this.maxIdleTime = (int)((float)this.maxIdleTime / ((efficiency + 100.0f) / 100.0f));
            } else if (efficiency < 0.0f) {
                this.maxIdleTime = (int)((float)this.maxIdleTime * (((efficiency *= -1.0f) + 100.0f) / 100.0f));
            }
            ItemStack strainerStack = this.getStrainer();
            if (strainerStack.m_41720_() instanceof ItemStrainer) {
                ItemStrainer strainerItem = (ItemStrainer)strainerStack.m_41720_();
                if (BlockStrainerBase.isStrainerInLiquid(this.f_58857_, this.f_58858_)) {
                    boolean requiresBait;
                    boolean bl = requiresBait = strainerItem.TYPE.category == ItemStrainer.StrainerCategory.FISHER;
                    if (requiresBait && !this.hasBait()) {
                        return;
                    }
                    boolean itemGenerated = false;
                    int fortuneRolls = ItemStrainer.generateBonusItem(strainerStack.getEnchantmentLevel(Enchantments.f_44987_)) ? 2 : 1;
                    int luckRolls = strainerStack.getEnchantmentLevel(Enchantments.f_44953_) + 1;
                    for (int i = 0; i < fortuneRolls; ++i) {
                        Optional<Object> loot = Optional.empty();
                        for (int j = 0; j < luckRolls; ++j) {
                            Optional<LootTable.Loot> tempLoot = strainerItem.LOOT_TABLE.getRandomLootFromTable();
                            if (!loot.isEmpty() && tempLoot.get().getRarity() >= ((LootTable.Loot)loot.get()).getRarity()) continue;
                            boolean luckProcced = loot.isPresent();
                            loot = tempLoot;
                            if (luckProcced) break;
                        }
                        if (!loot.isPresent()) continue;
                        itemGenerated = true;
                        ItemStack lootStack = ((LootTable.Loot)loot.get()).getStack();
                        if (lootStack.m_41720_() == Items.f_42690_ && EnchantedBookItem.m_41163_((ItemStack)lootStack).isEmpty()) {
                            lootStack = EnchantmentHelper.m_220292_((RandomSource)this.f_58857_.m_213780_(), (ItemStack)new ItemStack((ItemLike)Items.f_42517_), (int)(rand.nextInt((Integer)Config.MISC_BOOK_MAX_ENCHANTABILITY.get()) + 1), (boolean)true);
                        }
                        WaterStrainerUtils.addItemToInventory(lootStack, this.inv, 1, 27);
                    }
                    if (itemGenerated) {
                        if (requiresBait) {
                            this.consumeBait();
                        }
                        if (strainerStack.m_41763_()) {
                            if (!ItemStrainer.preventDamage(strainerStack.getEnchantmentLevel(Enchantments.f_44986_))) {
                                strainerStack.m_41721_(strainerStack.m_41773_() + 1);
                            }
                            if (strainerStack.m_41773_() >= strainerStack.m_41776_()) {
                                this.inv.setStackInSlot(0, ItemStack.f_41583_);
                            }
                        }
                        this.m_6596_();
                    }
                }
            }
        }
    }

    public static boolean isItemValidBait(ItemStack stack) {
        return ((List)Config.MISC_VALID_BAIT.get()).stream().anyMatch(baitRegName -> Objects.equals(baitRegName, String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()))));
    }

    private boolean hasBait() {
        ItemStack bait = this.inv.getStackInSlot(28);
        return !bait.m_41619_() && TileEntityStrainer.isItemValidBait(bait);
    }

    private void consumeBait() {
        ItemStack bait = this.inv.getStackInSlot(28);
        if (TileEntityStrainer.isItemValidBait(bait) && !(bait.m_41720_() instanceof ItemSuperWorm)) {
            ItemStack pot = this.inv.getStackInSlot(29);
            if (pot.m_41720_() instanceof ItemBaitPot && rand.nextInt(2) == 0) {
                pot.m_41721_(pot.m_41773_() + 1);
                if (pot.m_41773_() >= pot.m_41776_()) {
                    this.inv.setStackInSlot(29, ItemStack.f_41583_);
                }
                return;
            }
            bait.m_41774_(1);
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory invIn, Player playerIn) {
        return new ContainerStrainer(id, invIn, this.m_58899_(), this.syncValues);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.waterstrainer.strainer_base");
    }

    public class InventoryHandler
    extends ItemStackHandler {
        private final TileEntityStrainer tile;

        private InventoryHandler(TileEntityStrainer te) {
            super(30);
            this.tile = te;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                BlockStrainerBase.updateModel(this.tile);
            }
            this.tile.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot >= 0 && slot <= 0) {
                return stack.m_41720_() instanceof ItemStrainer;
            }
            if (slot >= 28 && slot <= 28) {
                return TileEntityStrainer.isItemValidBait(stack);
            }
            if (slot >= 29 && slot <= 29) {
                return stack.m_41720_() instanceof ItemBaitPot;
            }
            return true;
        }
    }
}

