/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

public class WaterStrainerUtils {
    public static boolean isInt(String number) {
        if (NumberUtils.isParsable((String)number)) {
            try {
                Integer.parseInt(number);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String formPlural(int number, String singular, String plural) {
        return number == 1 || number == -1 ? number + " " + singular : number + " " + plural;
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy - HH:mm:ss");
        return dateFormat.format(new Date());
    }

    public static String ctext(String text) {
        text = text.replace("#PURPLE#", ChatFormatting.DARK_PURPLE.toString());
        text = text.replace("#BLUE#", ChatFormatting.BLUE.toString());
        text = text.replace("#RED#", ChatFormatting.RED.toString());
        text = text.replace("#GREEN#", ChatFormatting.DARK_GREEN.toString());
        text = text.replace("#GOLD#", ChatFormatting.GOLD.toString());
        text = text.replace("#GRAY#", ChatFormatting.GRAY.toString());
        text = text.replace("#RESET#", ChatFormatting.RESET.toString());
        return text + ChatFormatting.RESET.toString();
    }

    public static void generateTooltip(List<Component> tooltip, List<String> text) {
        if (text != null) {
            for (String str : text) {
                tooltip.add((Component)Component.m_237113_((String)WaterStrainerUtils.ctext("#GRAY#" + str)));
            }
        }
    }

    public static int generateIntForChunk(Level world, BlockPos pos, int range) {
        int xPosition = pos.m_123341_() >> 4;
        int zPosition = pos.m_123343_() >> 4;
        Random rand = new Random(((WorldGenLevel)world).m_7328_() + (long)(xPosition * xPosition * 4987142) + (long)(xPosition * 5947611) + (long)(zPosition * zPosition) * 4392871L + (long)(zPosition * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(range);
    }

    public static void sendChatMessage(Player player, String text) {
        player.m_5661_((Component)Component.m_237113_((String)text), false);
    }

    public static boolean isUsableByPlayer(Player player, BlockPos pos) {
        return !(player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 64.0);
    }

    public static void dropInventoryItems(Level world, BlockPos pos, IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public static ItemStack addItemToInventory(ItemStack stack, TileEntityStrainer.InventoryHandler itemHandler, int startSlot, int endSlot) {
        if (stack != null && !stack.m_41619_() && itemHandler != null) {
            int slot;
            for (slot = startSlot; slot <= endSlot; ++slot) {
                if (itemHandler.getStackInSlot(slot).m_41619_() || !(stack = itemHandler.insertItem(slot, stack, false)).m_41619_()) continue;
                return stack;
            }
            for (slot = startSlot; slot <= endSlot; ++slot) {
                if (!itemHandler.getStackInSlot(slot).m_41619_() || !(stack = itemHandler.insertItem(slot, stack, false)).m_41619_()) continue;
                return stack;
            }
        }
        return stack;
    }

    public static void addEntityItemToInventory(ItemEntity entity, TileEntityStrainer.InventoryHandler itemHandler, int startSlot, int endSlot) {
        if (entity != null && itemHandler != null) {
            ItemStack stack = WaterStrainerUtils.addItemToInventory(entity.m_32055_().m_41777_(), itemHandler, startSlot, endSlot);
            if (stack.m_41619_()) {
                entity.m_146870_();
            } else {
                entity.m_32045_(stack);
            }
        }
    }

    public static Item getItemByName(String name) {
        Optional optionalItemReference;
        if (name != null && !Objects.equals(name, "$BLANK$") && (optionalItemReference = ForgeRegistries.ITEMS.getDelegate(new ResourceLocation(name))).isPresent() && ((Holder.Reference)optionalItemReference.get()).m_203633_()) {
            return (Item)((Holder.Reference)optionalItemReference.get()).get();
        }
        return null;
    }
}

