/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.activitylog.Activity;
import me.lucko.spark.common.command.Arguments;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.command.tabcomplete.CompletionSupplier;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.SamplerBuilder;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.async.AsyncSampler;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.util.FormatUtil;
import me.lucko.spark.common.util.MethodDisambiguator;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.event.ClickEvent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.proto.SparkSamplerProtos;

public class SamplerModule
implements CommandModule {
    private static final String SPARK_SAMPLER_MEDIA_TYPE = "application/x-spark-sampler";

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("profiler", "sampler").allowSubCommand(true).argumentUsage("info", "", null).argumentUsage("start", "timeout", "timeout seconds").argumentUsage("start", "thread *", null).argumentUsage("start", "thread", "thread name").argumentUsage("start", "only-ticks-over", "tick length millis").argumentUsage("start", "interval", "interval millis").argumentUsage("stop", "", null).argumentUsage("cancel", "", null).executor(this::profiler).tabCompleter((platform, sender, arguments) -> {
            List<String> opts = Collections.emptyList();
            if (arguments.size() > 0) {
                String subCommand = (String)arguments.get(0);
                if (subCommand.equals("stop") || subCommand.equals("upload")) {
                    opts = new ArrayList<String>(Arrays.asList("--comment", "--save-to-file"));
                    opts.removeAll(arguments);
                }
                if (subCommand.equals("start")) {
                    opts = new ArrayList<String>(Arrays.asList("--timeout", "--regex", "--combine-all", "--not-combined", "--interval", "--only-ticks-over", "--force-java-sampler"));
                    opts.removeAll(arguments);
                    opts.add("--thread");
                }
            }
            return TabCompleter.create().at(0, CompletionSupplier.startsWith(Arrays.asList("info", "start", "stop", "cancel"))).from(1, CompletionSupplier.startsWith(opts)).complete(arguments);
        }).build());
    }

    private void profiler(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        String subCommand;
        String string = subCommand = arguments.subCommand() == null ? "" : arguments.subCommand();
        if (subCommand.equals("info") || arguments.boolFlag("info")) {
            this.profilerInfo(platform, resp);
            return;
        }
        if (subCommand.equals("cancel") || arguments.boolFlag("cancel")) {
            this.profilerCancel(platform, resp);
            return;
        }
        if (subCommand.equals("stop") || subCommand.equals("upload") || arguments.boolFlag("stop") || arguments.boolFlag("upload")) {
            this.profilerStop(platform, sender, resp, arguments);
            return;
        }
        if (subCommand.equals("start") || arguments.boolFlag("start")) {
            this.profilerStart(platform, sender, resp, arguments);
            return;
        }
        if (arguments.raw().isEmpty()) {
            this.profilerInfo(platform, resp);
        } else {
            this.profilerStart(platform, sender, resp, arguments);
        }
    }

    private void profilerStart(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        double intervalMillis;
        int timeoutSeconds;
        Sampler previousSampler = platform.getSamplerContainer().getActiveSampler();
        if (previousSampler != null) {
            if (previousSampler.isRunningInBackground()) {
                resp.replyPrefixed(Component.text("Stopping the background profiler before starting... please wait"));
                previousSampler.stop(true);
                platform.getSamplerContainer().unsetActiveSampler(previousSampler);
            } else {
                this.profilerInfo(platform, resp);
                return;
            }
        }
        if ((timeoutSeconds = arguments.intFlag("timeout")) != -1 && timeoutSeconds <= 10) {
            resp.replyPrefixed(Component.text("The specified timeout is not long enough for accurate results to be formed. Please choose a value greater than 10.", (TextColor)NamedTextColor.RED));
            return;
        }
        if (timeoutSeconds != -1 && timeoutSeconds < 30) {
            resp.replyPrefixed(Component.text("The accuracy of the output will significantly improve when the profiler is able to run for longer periods. Consider setting a timeout value over 30 seconds."));
        }
        if ((intervalMillis = arguments.doubleFlag("interval")) <= 0.0) {
            intervalMillis = 4.0;
        }
        boolean ignoreSleeping = arguments.boolFlag("ignore-sleeping");
        boolean ignoreNative = arguments.boolFlag("ignore-native");
        boolean forceJavaSampler = arguments.boolFlag("force-java-sampler");
        Set<String> threads = arguments.stringFlag("thread");
        ThreadDumper threadDumper = threads.isEmpty() ? platform.getPlugin().getDefaultThreadDumper() : (threads.contains("*") ? ThreadDumper.ALL : (arguments.boolFlag("regex") ? new ThreadDumper.Regex(threads) : new ThreadDumper.Specific(threads)));
        ThreadGrouper threadGrouper = arguments.boolFlag("combine-all") ? ThreadGrouper.AS_ONE : (arguments.boolFlag("not-combined") ? ThreadGrouper.BY_NAME : ThreadGrouper.BY_POOL);
        int ticksOver = arguments.intFlag("only-ticks-over");
        TickHook tickHook = null;
        if (ticksOver != -1 && (tickHook = platform.getTickHook()) == null) {
            resp.replyPrefixed(Component.text("Tick counting is not supported!", (TextColor)NamedTextColor.RED));
            return;
        }
        resp.broadcastPrefixed(Component.text("Starting a new profiler, please wait..."));
        SamplerBuilder builder = new SamplerBuilder();
        builder.threadDumper(threadDumper);
        builder.threadGrouper(threadGrouper);
        if (timeoutSeconds != -1) {
            builder.completeAfter(timeoutSeconds, TimeUnit.SECONDS);
        }
        builder.samplingInterval(intervalMillis);
        builder.ignoreSleeping(ignoreSleeping);
        builder.ignoreNative(ignoreNative);
        builder.forceJavaSampler(forceJavaSampler);
        if (ticksOver != -1) {
            builder.ticksOver(ticksOver, tickHook);
        }
        Sampler sampler = builder.start(platform);
        platform.getSamplerContainer().setActiveSampler(sampler);
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Profiler is now running!", (TextColor)NamedTextColor.GOLD))).append((Component)Component.space())).append((Component)Component.text("(" + (sampler instanceof AsyncSampler ? "async" : "built-in java") + ")", (TextColor)NamedTextColor.DARK_GRAY))).build());
        if (timeoutSeconds == -1) {
            resp.broadcastPrefixed(Component.text("It will run in the background until it is stopped by an admin."));
            resp.broadcastPrefixed(Component.text("To stop the profiler and upload the results, run:"));
            resp.broadcastPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler stop"));
        } else {
            resp.broadcastPrefixed(Component.text("The results will be automatically returned after the profiler has been running for " + FormatUtil.formatSeconds(timeoutSeconds) + "."));
        }
        CompletableFuture<Sampler> future = sampler.getFuture();
        future.whenCompleteAsync((s, throwable) -> {
            if (throwable != null) {
                resp.broadcastPrefixed(Component.text("Profiler operation failed unexpectedly. Error: " + throwable.toString(), (TextColor)NamedTextColor.RED));
                throwable.printStackTrace();
            }
        });
        sampler.getFuture().whenCompleteAsync((s, throwable) -> platform.getSamplerContainer().unsetActiveSampler((Sampler)s));
        if (timeoutSeconds != -1) {
            String comment = (String)Iterables.getFirst(arguments.stringFlag("comment"), null);
            MethodDisambiguator methodDisambiguator = new MethodDisambiguator();
            MergeMode mergeMode = arguments.boolFlag("separate-parent-calls") ? MergeMode.separateParentCalls(methodDisambiguator) : MergeMode.sameMethod(methodDisambiguator);
            boolean saveToFile = arguments.boolFlag("save-to-file");
            future.thenAcceptAsync(s -> {
                resp.broadcastPrefixed(Component.text("The active profiler has completed! Uploading results..."));
                this.handleUpload(platform, resp, (Sampler)s, comment, mergeMode, saveToFile);
            });
        }
    }

    private void profilerInfo(SparkPlatform platform, CommandResponseHandler resp) {
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed(Component.text("The profiler isn't running!"));
            resp.replyPrefixed(Component.text("To start a new one, run:"));
            resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler start"));
        } else {
            resp.replyPrefixed(Component.text("Profiler is already running!", (TextColor)NamedTextColor.GOLD));
            long runningTime = (System.currentTimeMillis() - sampler.getStartTime()) / 1000L;
            if (sampler.isRunningInBackground()) {
                resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("It was started "))).append((Component)Component.text("automatically", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(" when spark enabled and has been running in the background for " + FormatUtil.formatSeconds(runningTime) + "."))).build());
            } else {
                resp.replyPrefixed(Component.text("So far, it has profiled for " + FormatUtil.formatSeconds(runningTime) + "."));
            }
            long timeout = sampler.getAutoEndTime();
            if (timeout == -1L) {
                resp.replyPrefixed(Component.text("To stop the profiler and upload the results, run:"));
                resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler stop"));
            } else {
                long timeoutDiff = (timeout - System.currentTimeMillis()) / 1000L;
                resp.replyPrefixed(Component.text("It is due to complete automatically and upload results in " + FormatUtil.formatSeconds(timeoutDiff) + "."));
            }
            resp.replyPrefixed(Component.text("To cancel the profiler without uploading the results, run:"));
            resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler cancel"));
        }
    }

    private void profilerCancel(SparkPlatform platform, CommandResponseHandler resp) {
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed(Component.text("There isn't an active profiler running."));
        } else {
            platform.getSamplerContainer().stopActiveSampler(true);
            resp.broadcastPrefixed(Component.text("Profiler has been cancelled.", (TextColor)NamedTextColor.GOLD));
        }
    }

    private void profilerStop(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed(Component.text("There isn't an active profiler running."));
        } else {
            platform.getSamplerContainer().unsetActiveSampler(sampler);
            sampler.stop(false);
            boolean saveToFile = arguments.boolFlag("save-to-file");
            if (saveToFile) {
                resp.broadcastPrefixed(Component.text("Stopping the profiler & saving results, please wait..."));
            } else {
                resp.broadcastPrefixed(Component.text("Stopping the profiler & uploading results, please wait..."));
            }
            String comment = (String)Iterables.getFirst(arguments.stringFlag("comment"), null);
            MethodDisambiguator methodDisambiguator = new MethodDisambiguator();
            MergeMode mergeMode = arguments.boolFlag("separate-parent-calls") ? MergeMode.separateParentCalls(methodDisambiguator) : MergeMode.sameMethod(methodDisambiguator);
            this.handleUpload(platform, resp, sampler, comment, mergeMode, saveToFile);
            if (platform.getBackgroundSamplerManager().restartBackgroundSampler()) {
                resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Restarted the background profiler. "))).append((Component)Component.text("(If you don't want this to happen, run: /" + platform.getPlugin().getCommandName() + " profiler cancel)", (TextColor)NamedTextColor.DARK_GRAY))).build());
            }
        }
    }

    private void handleUpload(SparkPlatform platform, CommandResponseHandler resp, Sampler sampler, String comment, MergeMode mergeMode, boolean saveToFileFlag) {
        SparkSamplerProtos.SamplerData output = sampler.toProto(platform, resp.sender(), comment, mergeMode, ClassSourceLookup.create(platform));
        boolean saveToFile = false;
        if (saveToFileFlag) {
            saveToFile = true;
        } else {
            try {
                String key = platform.getBytebinClient().postContent(output, SPARK_SAMPLER_MEDIA_TYPE).key();
                String url = platform.getViewerUrl() + key;
                resp.broadcastPrefixed(Component.text("Profiler stopped & upload complete!", (TextColor)NamedTextColor.GOLD));
                resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).color(NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl(url))).build());
                platform.getActivityLog().addToLog(Activity.urlActivity(resp.sender(), System.currentTimeMillis(), "Profiler", url));
            }
            catch (Exception e) {
                resp.broadcastPrefixed(Component.text("An error occurred whilst uploading the results. Attempting to save to disk instead.", (TextColor)NamedTextColor.RED));
                e.printStackTrace();
                saveToFile = true;
            }
        }
        if (saveToFile) {
            Path file = platform.resolveSaveFile("profile", "sparkprofile");
            try {
                Files.write(file, output.toByteArray(), new OpenOption[0]);
                resp.broadcastPrefixed(Component.text("Profiler stopped & save complete!", (TextColor)NamedTextColor.GOLD));
                resp.broadcastPrefixed(Component.text("Data has been written to: " + file));
                resp.broadcastPrefixed(Component.text("You can view the profile file using the web app @ " + platform.getViewerUrl(), (TextColor)NamedTextColor.GRAY));
                platform.getActivityLog().addToLog(Activity.fileActivity(resp.sender(), System.currentTimeMillis(), "Profiler", file.toString()));
            }
            catch (IOException e) {
                resp.broadcastPrefixed(Component.text("An error occurred whilst saving the data.", (TextColor)NamedTextColor.RED));
                e.printStackTrace();
            }
        }
    }

    private static Component cmdPrompt(String cmd) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("  "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(cmd).color(NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand(cmd))).build())).build();
    }
}

