/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.sampler.AbstractSampler;
import me.lucko.spark.common.sampler.SamplerSettings;
import me.lucko.spark.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.AsyncProfilerJob;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.window.ProfilingWindowUtils;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.proto.SparkSamplerProtos;

public class AsyncSampler
extends AbstractSampler {
    private final AsyncProfilerAccess profilerAccess;
    private final AsyncDataAggregator dataAggregator;
    private final Object[] currentJobMutex = new Object[0];
    private AsyncProfilerJob currentJob;
    private ScheduledExecutorService scheduler;

    public AsyncSampler(SparkPlatform platform, SamplerSettings settings) {
        super(platform, settings);
        this.profilerAccess = AsyncProfilerAccess.getInstance(platform);
        this.dataAggregator = new AsyncDataAggregator(settings.threadGrouper());
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("spark-asyncsampler-worker-thread").build());
    }

    @Override
    public void start() {
        super.start();
        TickHook tickHook = this.platform.getTickHook();
        if (tickHook != null) {
            this.windowStatisticsCollector.startCountingTicks(tickHook);
        }
        int window = ProfilingWindowUtils.windowNow();
        AsyncProfilerJob job = this.profilerAccess.startNewProfilerJob();
        job.init(this.platform, this.interval, this.threadDumper, window, this.background);
        job.start();
        this.currentJob = job;
        this.scheduler.scheduleAtFixedRate(this::rotateProfilerJob, 60L, 60L, TimeUnit.SECONDS);
        this.recordInitialGcStats();
        this.scheduleTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateProfilerJob() {
        try {
            Object[] objectArray = this.currentJobMutex;
            synchronized (this.currentJobMutex) {
                AsyncProfilerJob previousJob = this.currentJob;
                if (previousJob == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    previousJob.stop();
                    this.windowStatisticsCollector.measureNow(previousJob.getWindow());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int window = previousJob.getWindow() + 1;
                AsyncProfilerJob newJob = this.profilerAccess.startNewProfilerJob();
                newJob.init(this.platform, this.interval, this.threadDumper, window, this.background);
                newJob.start();
                this.currentJob = newJob;
                previousJob.aggregate(this.dataAggregator);
                IntPredicate predicate = ProfilingWindowUtils.keepHistoryBefore(window);
                this.dataAggregator.pruneData(predicate);
                this.windowStatisticsCollector.pruneStatistics(predicate);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        {
            return;
        }
    }

    private void scheduleTimeout() {
        if (this.autoEndTime == -1L) {
            return;
        }
        long delay = this.autoEndTime - System.currentTimeMillis();
        if (delay <= 0L) {
            return;
        }
        this.scheduler.schedule(() -> {
            this.stop(false);
            this.future.complete(this);
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean cancelled) {
        super.stop(cancelled);
        Object[] objectArray = this.currentJobMutex;
        synchronized (this.currentJobMutex) {
            this.currentJob.stop();
            if (!cancelled) {
                this.windowStatisticsCollector.measureNow(this.currentJob.getWindow());
                this.currentJob.aggregate(this.dataAggregator);
            } else {
                this.currentJob.deleteOutputFile();
            }
            this.currentJob = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            return;
        }
    }

    @Override
    public SparkSamplerProtos.SamplerData toProto(SparkPlatform platform, CommandSender creator, String comment, MergeMode mergeMode, ClassSourceLookup classSourceLookup) {
        SparkSamplerProtos.SamplerData.Builder proto = SparkSamplerProtos.SamplerData.newBuilder();
        this.writeMetadataToProto(proto, platform, creator, comment, this.dataAggregator);
        this.writeDataToProto(proto, this.dataAggregator, mergeMode, classSourceLookup);
        return (SparkSamplerProtos.SamplerData)proto.build();
    }
}

