/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.AbstractStubType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtilsKt {
    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull KotlinType $this$builtIns) {
        Intrinsics.checkNotNullParameter($this$builtIns, "<this>");
        KotlinBuiltIns kotlinBuiltIns = $this$builtIns.getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public static final KotlinType makeNullable(@NotNull KotlinType $this$makeNullable) {
        Intrinsics.checkNotNullParameter($this$makeNullable, "<this>");
        KotlinType kotlinType = TypeUtils.makeNullable($this$makeNullable);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNullable(this)");
        return kotlinType;
    }

    @NotNull
    public static final KotlinType makeNotNullable(@NotNull KotlinType $this$makeNotNullable) {
        Intrinsics.checkNotNullParameter($this$makeNotNullable, "<this>");
        KotlinType kotlinType = TypeUtils.makeNotNullable($this$makeNotNullable);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNotNullable(this)");
        return kotlinType;
    }

    public static final boolean isTypeParameter(@NotNull KotlinType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeParameter, "<this>");
        return TypeUtils.isTypeParameter($this$isTypeParameter);
    }

    public static final boolean containsTypeParameter(@NotNull KotlinType $this$containsTypeParameter) {
        Intrinsics.checkNotNullParameter($this$containsTypeParameter, "<this>");
        return TypeUtils.contains($this$containsTypeParameter, containsTypeParameter.1.INSTANCE);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinType $this$isSubtypeOf, @NotNull KotlinType superType) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, "<this>");
        Intrinsics.checkNotNullParameter(superType, "superType");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf($this$isSubtypeOf, superType);
    }

    @NotNull
    public static final KotlinType replaceAnnotations(@NotNull KotlinType $this$replaceAnnotations, @NotNull Annotations newAnnotations) {
        Intrinsics.checkNotNullParameter($this$replaceAnnotations, "<this>");
        Intrinsics.checkNotNullParameter(newAnnotations, "newAnnotations");
        if ($this$replaceAnnotations.getAnnotations().isEmpty() && newAnnotations.isEmpty()) {
            return $this$replaceAnnotations;
        }
        return $this$replaceAnnotations.unwrap().replaceAttributes(TypeAttributesKt.replaceAnnotations($this$replaceAnnotations.getAttributes(), newAnnotations));
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull KotlinType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter((Object)projectionKind, "projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl((typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null) == projectionKind ? Variance.INVARIANT : projectionKind, type2);
    }

    @NotNull
    public static final TypeProjection asTypeProjection(@NotNull KotlinType $this$asTypeProjection) {
        Intrinsics.checkNotNullParameter($this$asTypeProjection, "<this>");
        return new TypeProjectionImpl($this$asTypeProjection);
    }

    public static final boolean contains(@NotNull KotlinType $this$contains, @NotNull Function1<? super UnwrappedType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return TypeUtils.contains($this$contains, predicate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType replaceArgumentsWithStarProjections(@NotNull KotlinType $this$replaceArgumentsWithStarProjections) {
        UnwrappedType unwrappedType;
        UnwrappedType unwrapped$iv;
        Intrinsics.checkNotNullParameter($this$replaceArgumentsWithStarProjections, "<this>");
        KotlinType $this$replaceArgumentsByParametersWith$iv = $this$replaceArgumentsWithStarProjections;
        boolean $i$f$replaceArgumentsByParametersWith = false;
        UnwrappedType unwrappedType2 = unwrapped$iv = $this$replaceArgumentsByParametersWith$iv.unwrap();
        if (unwrappedType2 instanceof FlexibleType) {
            SimpleType simpleType2;
            List newArguments$iv$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv$iv$iv;
            SimpleType simpleType3;
            SimpleType $this$replaceArgumentsByParametersWith$iv$iv = ((FlexibleType)unwrapped$iv).getLowerBound();
            boolean $i$f$replaceArgumentsByParametersWith2 = false;
            if ($this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters().isEmpty() || $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getDeclarationDescriptor() == null) {
                simpleType3 = $this$replaceArgumentsByParametersWith$iv$iv;
            } else {
                List<TypeParameterDescriptor> list = $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "constructor.parameters");
                $this$map$iv$iv$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv$iv$iv;
                destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    void p0;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv$iv$iv;
                    collection = destination$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(new StarProjectionImpl((TypeParameterDescriptor)p0));
                }
                newArguments$iv$iv = (List)destination$iv$iv$iv$iv;
                simpleType3 = TypeSubstitutionKt.replace$default($this$replaceArgumentsByParametersWith$iv$iv, newArguments$iv$iv, null, 2, null);
            }
            $this$replaceArgumentsByParametersWith$iv$iv = ((FlexibleType)unwrapped$iv).getUpperBound();
            SimpleType simpleType4 = simpleType3;
            $i$f$replaceArgumentsByParametersWith2 = false;
            if ($this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters().isEmpty() || $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getDeclarationDescriptor() == null) {
                simpleType2 = $this$replaceArgumentsByParametersWith$iv$iv;
            } else {
                List<TypeParameterDescriptor> list = $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "constructor.parameters");
                $this$map$iv$iv$iv = list;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
                destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    void p0;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv$iv$iv;
                    collection = destination$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(new StarProjectionImpl((TypeParameterDescriptor)p0));
                }
                newArguments$iv$iv = (List)destination$iv$iv$iv$iv;
                simpleType2 = TypeSubstitutionKt.replace$default($this$replaceArgumentsByParametersWith$iv$iv, newArguments$iv$iv, null, 2, null);
            }
            unwrappedType = KotlinTypeFactory.flexibleType(simpleType4, simpleType2);
        } else if (unwrappedType2 instanceof SimpleType) {
            SimpleType simpleType5;
            SimpleType $this$replaceArgumentsByParametersWith$iv$iv = (SimpleType)unwrapped$iv;
            boolean $i$f$replaceArgumentsByParametersWith3 = false;
            if ($this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters().isEmpty() || $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getDeclarationDescriptor() == null) {
                simpleType5 = $this$replaceArgumentsByParametersWith$iv$iv;
            } else {
                List<TypeParameterDescriptor> list = $this$replaceArgumentsByParametersWith$iv$iv.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "constructor.parameters");
                Iterable $this$map$iv$iv$iv = list;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    TypeParameterDescriptor p0 = (TypeParameterDescriptor)item$iv$iv$iv$iv;
                    Collection collection = destination$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(new StarProjectionImpl(p0));
                }
                List newArguments$iv$iv = (List)destination$iv$iv$iv$iv;
                simpleType5 = TypeSubstitutionKt.replace$default($this$replaceArgumentsByParametersWith$iv$iv, newArguments$iv$iv, null, 2, null);
            }
            unwrappedType = simpleType5;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, unwrapped$iv);
    }

    @NotNull
    public static final Set<TypeParameterDescriptor> extractTypeParametersFromUpperBounds(@NotNull KotlinType $this$extractTypeParametersFromUpperBounds, @Nullable Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        Set set;
        Intrinsics.checkNotNullParameter($this$extractTypeParametersFromUpperBounds, "<this>");
        Set it = set = (Set)new LinkedHashSet();
        boolean bl = false;
        TypeUtilsKt.extractTypeParametersFromUpperBounds($this$extractTypeParametersFromUpperBounds, $this$extractTypeParametersFromUpperBounds, it, visitedTypeParameters);
        return set;
    }

    private static final void extractTypeParametersFromUpperBounds(KotlinType $this$extractTypeParametersFromUpperBounds, KotlinType baseType, Set<TypeParameterDescriptor> to, Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        ClassifierDescriptor declarationDescriptor = $this$extractTypeParametersFromUpperBounds.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            if (!Intrinsics.areEqual($this$extractTypeParametersFromUpperBounds.getConstructor(), baseType.getConstructor())) {
                ((Collection)to).add(declarationDescriptor);
            } else {
                for (KotlinType upperBound : ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds()) {
                    Intrinsics.checkNotNullExpressionValue(upperBound, "upperBound");
                    TypeUtilsKt.extractTypeParametersFromUpperBounds(upperBound, baseType, to, visitedTypeParameters);
                }
            }
        } else {
            ClassifierDescriptor classifierDescriptor = $this$extractTypeParametersFromUpperBounds.getConstructor().getDeclarationDescriptor();
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            List<TypeParameterDescriptor> typeParameters2 = classifierDescriptorWithTypeParameters != null ? classifierDescriptorWithTypeParameters.getDeclaredTypeParameters() : null;
            Iterator<TypeProjection> iterator2 = $this$extractTypeParametersFromUpperBounds.getArguments().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i2 = n++;
                TypeProjection argument = iterator2.next();
                List<TypeParameterDescriptor> list = typeParameters2;
                TypeParameterDescriptor typeParameter = list != null ? CollectionsKt.getOrNull(list, i2) : null;
                boolean isTypeParameterVisited = typeParameter != null && visitedTypeParameters != null && visitedTypeParameters.contains(typeParameter);
                if (isTypeParameterVisited || argument.isStarProjection() || CollectionsKt.contains((Iterable)to, argument.getType().getConstructor().getDeclarationDescriptor()) || Intrinsics.areEqual(argument.getType().getConstructor(), baseType.getConstructor())) continue;
                KotlinType kotlinType = argument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.type");
                TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType, baseType, to, visitedTypeParameters);
            }
        }
    }

    @JvmOverloads
    public static final boolean hasTypeParameterRecursiveBounds(@NotNull TypeParameterDescriptor typeParameter, @Nullable TypeConstructor selfConstructor, @Nullable Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            List<KotlinType> list = typeParameter.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "typeParameter.upperBounds");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType upperBound = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(upperBound, "upperBound");
                    boolean bl3 = TypeUtilsKt.containsSelfTypeParameter(upperBound, typeParameter.getDefaultType().getConstructor(), visitedTypeParameters) && (selfConstructor == null || Intrinsics.areEqual(upperBound.getConstructor(), selfConstructor));
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean hasTypeParameterRecursiveBounds$default(TypeParameterDescriptor typeParameterDescriptor, TypeConstructor typeConstructor2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        return TypeUtilsKt.hasTypeParameterRecursiveBounds(typeParameterDescriptor, typeConstructor2, set);
    }

    private static final boolean containsSelfTypeParameter(KotlinType $this$containsSelfTypeParameter, TypeConstructor baseConstructor, Set<? extends TypeParameterDescriptor> visitedTypeParameters) {
        boolean bl;
        block6: {
            if (Intrinsics.areEqual($this$containsSelfTypeParameter.getConstructor(), baseConstructor)) {
                return true;
            }
            ClassifierDescriptor classifierDescriptor = $this$containsSelfTypeParameter.getConstructor().getDeclarationDescriptor();
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            List<TypeParameterDescriptor> typeParameters2 = classifierDescriptorWithTypeParameters != null ? classifierDescriptorWithTypeParameters.getDeclaredTypeParameters() : null;
            Iterable $this$any$iv = CollectionsKt.withIndex((Iterable)$this$containsSelfTypeParameter.getArguments());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    boolean bl2;
                    boolean isTypeParameterVisited;
                    IndexedValue element$iv;
                    IndexedValue indexedValue = element$iv = iterator2.next();
                    boolean bl3 = false;
                    int i2 = indexedValue.component1();
                    TypeProjection argument = (TypeProjection)indexedValue.component2();
                    List<TypeParameterDescriptor> list = typeParameters2;
                    TypeParameterDescriptor typeParameter = list != null ? CollectionsKt.getOrNull(list, i2) : null;
                    boolean bl4 = isTypeParameterVisited = typeParameter != null && visitedTypeParameters != null && visitedTypeParameters.contains(typeParameter);
                    if (isTypeParameterVisited || argument.isStarProjection()) {
                        bl2 = false;
                    } else {
                        KotlinType kotlinType = argument.getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.type");
                        bl2 = TypeUtilsKt.containsSelfTypeParameter(kotlinType, baseConstructor, visitedTypeParameters);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean containsTypeAliasParameters(@NotNull KotlinType $this$containsTypeAliasParameters) {
        Intrinsics.checkNotNullParameter($this$containsTypeAliasParameters, "<this>");
        return TypeUtilsKt.contains($this$containsTypeAliasParameters, containsTypeAliasParameters.1.INSTANCE);
    }

    public static final boolean isTypeAliasParameter(@NotNull ClassifierDescriptor $this$isTypeAliasParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeAliasParameter, "<this>");
        return $this$isTypeAliasParameter instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)$this$isTypeAliasParameter).getContainingDeclaration() instanceof TypeAliasDescriptor;
    }

    public static final boolean requiresTypeAliasExpansion(@NotNull KotlinType $this$requiresTypeAliasExpansion) {
        Intrinsics.checkNotNullParameter($this$requiresTypeAliasExpansion, "<this>");
        return TypeUtilsKt.contains($this$requiresTypeAliasExpansion, requiresTypeAliasExpansion.1.INSTANCE);
    }

    @NotNull
    public static final KotlinType getRepresentativeUpperBound(@NotNull TypeParameterDescriptor $this$representativeUpperBound) {
        KotlinType kotlinType;
        Object v4;
        block3: {
            boolean bl;
            Intrinsics.checkNotNullParameter($this$representativeUpperBound, "<this>");
            List<KotlinType> list = $this$representativeUpperBound.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "upperBounds");
            boolean bl2 = bl = !((Collection)list).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-TypeUtilsKt$representativeUpperBound$22 = false;
                String $i$a$-assert-TypeUtilsKt$representativeUpperBound$22 = "Upper bounds should not be empty: " + $this$representativeUpperBound;
                throw new AssertionError((Object)$i$a$-assert-TypeUtilsKt$representativeUpperBound$22);
            }
            List<KotlinType> list2 = $this$representativeUpperBound.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, "upperBounds");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClassDescriptor classDescriptor;
                KotlinType it = (KotlinType)element$iv;
                boolean bl3 = false;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (!(classDescriptor2 == null ? false : (classDescriptor = classDescriptor2).getKind() != ClassKind.INTERFACE && classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS)) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        if ((kotlinType = (KotlinType)v4) == null) {
            List<KotlinType> list = $this$representativeUpperBound.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "upperBounds");
            KotlinType kotlinType2 = CollectionsKt.first(list);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "upperBounds.first()");
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    public static final boolean shouldBeUpdated(@Nullable KotlinType $this$shouldBeUpdated) {
        return $this$shouldBeUpdated == null || TypeUtilsKt.contains($this$shouldBeUpdated, shouldBeUpdated.1.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStubType(@NotNull KotlinType $this$isStubType) {
        Intrinsics.checkNotNullParameter($this$isStubType, "<this>");
        if ($this$isStubType instanceof AbstractStubType) return true;
        KotlinType $this$isDefNotNullStubType$iv = $this$isStubType;
        boolean $i$f$isDefNotNullStubType = false;
        if (!($this$isDefNotNullStubType$iv instanceof DefinitelyNotNullType)) return false;
        if (!(((DefinitelyNotNullType)$this$isDefNotNullStubType$iv).getOriginal() instanceof AbstractStubType)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStubTypeForBuilderInference(@NotNull KotlinType $this$isStubTypeForBuilderInference) {
        Intrinsics.checkNotNullParameter($this$isStubTypeForBuilderInference, "<this>");
        if ($this$isStubTypeForBuilderInference instanceof StubTypeForBuilderInference) return true;
        KotlinType $this$isDefNotNullStubType$iv = $this$isStubTypeForBuilderInference;
        boolean $i$f$isDefNotNullStubType = false;
        if (!($this$isDefNotNullStubType$iv instanceof DefinitelyNotNullType)) return false;
        if (!(((DefinitelyNotNullType)$this$isDefNotNullStubType$iv).getOriginal() instanceof StubTypeForBuilderInference)) return false;
        return true;
    }

    public static final boolean isUnresolvedType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return type2 instanceof ErrorType && ((ErrorType)type2).getKind().isUnresolved();
    }

    @JvmOverloads
    public static final boolean hasTypeParameterRecursiveBounds(@NotNull TypeParameterDescriptor typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        return TypeUtilsKt.hasTypeParameterRecursiveBounds$default(typeParameter, null, null, 6, null);
    }
}

