/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.entity;

import de.maxhenkel.easyvillagers.Main;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;

public class EasyVillagerEntity
extends Villager {
    public EasyVillagerEntity(EntityType<? extends Villager> type, Level worldIn) {
        super(type, worldIn);
    }

    public EasyVillagerEntity(EntityType<? extends Villager> type, Level worldIn, VillagerType villagerType) {
        super(type, worldIn, villagerType);
    }

    public int m_35532_(Player player) {
        if (((Boolean)Main.SERVER_CONFIG.universalReputation.get()).booleanValue()) {
            return EasyVillagerEntity.getUniversalReputation(this);
        }
        return super.m_35532_(player);
    }

    public static int getReputation(Villager villager) {
        if (((Boolean)Main.SERVER_CONFIG.universalReputation.get()).booleanValue()) {
            return EasyVillagerEntity.getUniversalReputation(villager);
        }
        return 0;
    }

    public static int getUniversalReputation(Villager villager) {
        return villager.m_35517_().m_148159_().keySet().stream().map(uuid -> villager.m_35517_().m_26195_(uuid, EasyVillagerEntity::isPositive)).reduce(0, Integer::sum);
    }

    public static boolean isPositive(GossipType gossipType) {
        return switch (gossipType) {
            case GossipType.MAJOR_NEGATIVE, GossipType.MINOR_NEGATIVE -> false;
            default -> true;
        };
    }

    public void recalculateOffers() {
        EasyVillagerEntity.resetOffers(this);
        EasyVillagerEntity.calculateOffers(this);
    }

    public int m_146764_() {
        if (this.f_19853_.f_46443_) {
            return super.m_146764_() < 0 ? -24000 : 1;
        }
        return this.f_146733_;
    }

    public static void recalculateOffers(Villager villager) {
        EasyVillagerEntity.resetOffers(villager);
        EasyVillagerEntity.calculateOffers(villager);
    }

    private static void resetOffers(Villager villager) {
        for (MerchantOffer merchantoffer : villager.m_6616_()) {
            merchantoffer.m_45376_();
        }
    }

    private static void calculateOffers(Villager villager) {
        int i = EasyVillagerEntity.getReputation(villager);
        if (i != 0) {
            for (MerchantOffer merchantoffer : villager.m_6616_()) {
                merchantoffer.m_45353_(-Mth.m_14143_((float)((float)i * merchantoffer.m_45378_())));
            }
        }
    }

    public Component m_7755_() {
        if (this.m_8077_()) {
            return super.m_7755_();
        }
        VillagerData villagerData = this.m_7141_();
        VillagerProfession profession = villagerData.m_35571_();
        if (profession.equals((Object)VillagerProfession.f_35585_)) {
            return EntityType.f_20492_.m_20676_().m_6881_();
        }
        return this.m_5677_();
    }

    public Component getAdvancedName() {
        return Component.m_237110_((String)"tooltip.easy_villagers.villager_profession", (Object[])new Object[]{this.m_7755_().m_6881_(), Component.m_237115_((String)("merchant.level." + this.m_7141_().m_35576_()))}).m_130940_(ChatFormatting.GRAY);
    }
}

