/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.forge;

import java.util.HashMap;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import samebutdifferent.ecologics.Ecologics;
import samebutdifferent.ecologics.block.FloweringAzaleaLogBlock;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.platform.forge.CommonPlatformHelperImpl;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.forge.ModConfigForge;
import samebutdifferent.ecologics.registry.forge.ModGlobalLootModifiers;

@Mod(value="ecologics")
@Mod.EventBusSubscriber(modid="ecologics")
public class EcologicsForge {
    public static CreativeModeTab TAB;

    public EcologicsForge() {
        Ecologics.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigForge.COMMON_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonPlatformHelperImpl.BLOCKS.register(bus);
        CommonPlatformHelperImpl.ITEMS.register(bus);
        CommonPlatformHelperImpl.SOUND_EVENTS.register(bus);
        CommonPlatformHelperImpl.ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.BLOCK_ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.FEATURES.register(bus);
        CommonPlatformHelperImpl.TRUNK_PLACER_TYPES.register(bus);
        CommonPlatformHelperImpl.FOLIAGE_PLACER_TYPES.register(bus);
        CommonPlatformHelperImpl.MOB_EFFECTS.register(bus);
        CommonPlatformHelperImpl.POTIONS.register(bus);
        ModGlobalLootModifiers.GLM.register(bus);
        bus.addListener(this::registerEntityAttributes);
        bus.addListener(this::setup);
        bus.addListener(this::registerCreativeTab);
    }

    public void registerEntityAttributes(EntityAttributeCreationEvent event) {
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        Ecologics.registerEntityAttributes(attributes);
        attributes.forEach((entity, builder) -> event.put(entity, builder.m_22265_()));
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Ecologics.commonSetup());
    }

    private void registerCreativeTab(CreativeModeTabEvent.Register event) {
        TAB = event.registerCreativeModeTab(new ResourceLocation("ecologics", "tab"), builder -> builder.m_257737_(() -> ModBlocks.COCONUT_LOG.get().m_5456_().m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.ecologics.tab")).m_257501_((features, output, hasPermissions) -> output.m_246601_(Stream.of(ModBlocks.COCONUT_LOG, ModBlocks.STRIPPED_COCONUT_LOG, ModBlocks.COCONUT_WOOD, ModBlocks.STRIPPED_COCONUT_WOOD, ModBlocks.COCONUT_LEAVES, ModBlocks.COCONUT_PLANKS, ModBlocks.COCONUT_SLAB, ModBlocks.COCONUT_STAIRS, ModBlocks.COCONUT_FENCE, ModBlocks.COCONUT_FENCE_GATE, ModBlocks.COCONUT_DOOR, ModBlocks.COCONUT_TRAPDOOR, ModBlocks.COCONUT_BUTTON, ModBlocks.COCONUT_PRESSURE_PLATE, ModBlocks.COCONUT, ModBlocks.COCONUT_SEEDLING, ModBlocks.SEASHELL, ModBlocks.SEASHELL_BLOCK, ModBlocks.SEASHELL_TILES, ModBlocks.SEASHELL_TILE_STAIRS, ModBlocks.SEASHELL_TILE_SLAB, ModBlocks.SEASHELL_TILE_WALL, ModBlocks.POT, ModBlocks.THIN_ICE, ModBlocks.ICE_BRICKS, ModBlocks.ICE_BRICK_STAIRS, ModBlocks.ICE_BRICK_SLAB, ModBlocks.ICE_BRICK_WALL, ModBlocks.SNOW_BRICKS, ModBlocks.SNOW_BRICK_STAIRS, ModBlocks.SNOW_BRICK_SLAB, ModBlocks.SNOW_BRICK_WALL, ModBlocks.WALNUT_LOG, ModBlocks.STRIPPED_WALNUT_LOG, ModBlocks.WALNUT_WOOD, ModBlocks.STRIPPED_WALNUT_WOOD, ModBlocks.WALNUT_LEAVES, ModBlocks.WALNUT_PLANKS, ModBlocks.WALNUT_SLAB, ModBlocks.WALNUT_STAIRS, ModBlocks.WALNUT_FENCE, ModBlocks.WALNUT_FENCE_GATE, ModBlocks.WALNUT_DOOR, ModBlocks.WALNUT_TRAPDOOR, ModBlocks.WALNUT_BUTTON, ModBlocks.WALNUT_PRESSURE_PLATE, ModBlocks.WALNUT_SAPLING, ModBlocks.AZALEA_LOG, ModBlocks.FLOWERING_AZALEA_LOG, ModBlocks.STRIPPED_AZALEA_LOG, ModBlocks.AZALEA_WOOD, ModBlocks.FLOWERING_AZALEA_WOOD, ModBlocks.STRIPPED_AZALEA_WOOD, ModBlocks.AZALEA_PLANKS, ModBlocks.FLOWERING_AZALEA_PLANKS, ModBlocks.AZALEA_SLAB, ModBlocks.FLOWERING_AZALEA_SLAB, ModBlocks.AZALEA_STAIRS, ModBlocks.FLOWERING_AZALEA_STAIRS, ModBlocks.AZALEA_FENCE, ModBlocks.FLOWERING_AZALEA_FENCE, ModBlocks.AZALEA_FENCE_GATE, ModBlocks.FLOWERING_AZALEA_FENCE_GATE, ModBlocks.AZALEA_DOOR, ModBlocks.FLOWERING_AZALEA_DOOR, ModBlocks.AZALEA_TRAPDOOR, ModBlocks.FLOWERING_AZALEA_TRAPDOOR, ModBlocks.AZALEA_BUTTON, ModBlocks.AZALEA_PRESSURE_PLATE, ModBlocks.AZALEA_FLOWER, ModBlocks.SURFACE_MOSS, ModItems.COCONUT_SLICE, ModItems.COCONUT_HUSK, ModItems.CRAB_CLAW, ModItems.CRAB_MEAT, ModItems.TROPICAL_STEW, ModItems.COCONUT_CRAB_SPAWN_EGG, ModItems.CAMEL_SPAWN_EGG, ModItems.PENGUIN_SPAWN_EGG, ModItems.SQUIRREL_SPAWN_EGG, ModItems.SANDCASTLE, ModItems.MUSIC_DISC_COCONUT, ModItems.COCONUT_SIGN, ModItems.PRICKLY_PEAR, ModItems.COOKED_PRICKLY_PEAR, ModItems.PENGUIN_FEATHER, ModItems.WALNUT_SIGN, ModItems.WALNUT, ModItems.AZALEA_SIGN, ModItems.FLOWERING_AZALEA_SIGN, ModItems.COCONUT_BOAT, ModItems.WALNUT_BOAT, ModItems.AZALEA_BOAT, ModItems.FLOWERING_AZALEA_BOAT, ModItems.COCONUT_CHEST_BOAT, ModItems.WALNUT_CHEST_BOAT, ModItems.AZALEA_CHEST_BOAT, ModItems.FLOWERING_AZALEA_CHEST_BOAT).map(block -> ((ItemLike)((FeatureElement)block.get())).m_5456_().m_7968_()).toList())));
    }

    @SubscribeEvent
    public static void onCropGrow(BlockEvent.CropGrowEvent.Post event) {
        BlockPos pos = event.getPos();
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        if (state.m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50128_) && level.m_46859_(pos.m_6630_(2)) && (double)level.m_213780_().m_188501_() <= (Double)ModConfigForge.PRICKLY_PEAR_GROWTH_CHANCE.get()) {
            level.m_7731_(pos.m_6630_(2), ModBlocks.PRICKLY_PEAR.get().m_49966_(), 2);
            level.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        InteractionHand hand = event.getHand();
        if (state.m_60713_((Block)ModBlocks.POT.get()) && player.m_6047_()) {
            if (player.m_21205_().m_41720_() instanceof PickaxeItem && hand.equals((Object)InteractionHand.MAIN_HAND)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.MAIN_HAND);
                player.m_21205_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.MAIN_HAND));
            }
            if (player.m_21206_().m_41720_() instanceof PickaxeItem && !(player.m_21205_().m_41720_() instanceof PickaxeItem) && hand.equals((Object)InteractionHand.OFF_HAND)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.OFF_HAND);
                player.m_21206_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.OFF_HAND));
            }
        }
        if (!event.getLevel().f_46443_) {
            Direction direction;
            ItemStack stack = event.getItemStack();
            Direction direction2 = direction = event.getHitVec().m_82434_().m_122434_() == Direction.Axis.Y ? event.getHitVec().m_82434_().m_122424_() : event.getHitVec().m_82434_();
            if (stack.m_150930_(Items.f_42574_)) {
                if (state.m_60713_(Blocks.f_152542_)) {
                    FloweringAzaleaLogBlock.shearAzalea(level, player, pos, stack, hand, direction, Blocks.f_152541_.m_49966_());
                    player.m_21011_(hand, true);
                }
                if (state.m_60713_(Blocks.f_152471_)) {
                    FloweringAzaleaLogBlock.shearAzalea(level, player, pos, stack, hand, direction, (BlockState)((BlockState)Blocks.f_152470_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)state.m_61143_((Property)LeavesBlock.f_54418_))));
                    player.m_21011_(hand, true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(ForgeRegistries.BLOCKS.getRegistryKey())) {
            ResourceLocation remapped;
            if (mapping.getKey().equals((Object)new ResourceLocation("ecologics", "coconut_husk"))) {
                remapped = new ResourceLocation("ecologics", "coconut_seedling");
                if (ForgeRegistries.BLOCKS.containsKey(remapped)) {
                    mapping.remap((Object)((Block)ForgeRegistries.BLOCKS.getValue(remapped)));
                } else {
                    mapping.warn();
                }
            }
            if (!mapping.getKey().equals((Object)new ResourceLocation("ecologics", "potted_coconut_husk"))) continue;
            remapped = new ResourceLocation("ecologics", "potted_coconut_seedling");
            if (ForgeRegistries.BLOCKS.containsKey(remapped)) {
                mapping.remap((Object)((Block)ForgeRegistries.BLOCKS.getValue(remapped)));
                continue;
            }
            mapping.warn();
        }
    }
}

