/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.blocks.cake;

import com.mrbysco.telepastries.TelePastries;
import com.mrbysco.telepastries.blocks.BlockPastryBase;
import com.mrbysco.telepastries.config.TeleConfig;
import com.mrbysco.telepastries.util.CakeTeleporter;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockCakeBase
extends BlockPastryBase {
    public static final IntegerProperty BITES = BlockStateProperties.f_61412_;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public BlockCakeBase(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)BITES)];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (this.consumeCake() && this.isRefillItem(stack)) {
            int i = (Integer)state.m_61143_((Property)BITES);
            if (i > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i - 1)), 3);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        } else if (this.canTeleportTo(level.m_46472_().m_135782_(), this.getCakeWorld().m_135782_())) {
            if (((Boolean)TeleConfig.COMMON.resetPastry.get()).booleanValue() && this.isResetItem(stack)) {
                if (level.f_46443_) {
                    this.removeDimensionPosition((ServerPlayer)player, this.getCakeWorld());
                }
                if (stack.m_41720_() == Items.f_42455_ && !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_42446_));
                }
            } else {
                this.eatSlice((LevelAccessor)level, pos, state, player);
            }
        } else {
            if (level.m_46472_().m_135782_().equals((Object)this.getCakeWorld().m_135782_())) {
                player.m_5661_((Component)Component.m_237115_((String)"telepastries.same_dimension"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"telepastries.teleport_restricted"), true);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public boolean canTeleportTo(ResourceLocation location, ResourceLocation toLocation) {
        if (((Boolean)TeleConfig.COMMON.disableHopping.get()).booleanValue()) {
            ResourceLocation overworldLocation = Level.f_46428_.m_135782_();
            if (location.equals((Object)overworldLocation)) {
                return !location.equals((Object)toLocation);
            }
            return toLocation.equals((Object)overworldLocation) && !location.equals((Object)overworldLocation);
        }
        return !location.equals((Object)toLocation);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (((Boolean)TeleConfig.COMMON.disableHopping.get()).booleanValue()) {
            ResourceLocation overworldLocation = Level.f_46428_.m_135782_();
            ResourceLocation worldLocation = ((Level)worldIn).m_46472_().m_135782_();
            if (worldLocation.equals((Object)overworldLocation)) {
                return !this.getCakeWorld().m_135782_().equals((Object)overworldLocation);
            }
            return this.getCakeWorld().m_135782_().equals((Object)overworldLocation);
        }
        return super.m_7898_(state, worldIn, pos);
    }

    private InteractionResult eatSlice(LevelAccessor levelAccessor, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(((Boolean)TeleConfig.COMMON.ignoreHunger.get()).booleanValue())) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(2, 0.1f);
        if (this.consumeCake() && !player.m_150110_().f_35937_) {
            int i = (Integer)state.m_61143_((Property)BITES);
            if (i < 6) {
                levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            } else {
                levelAccessor.m_7471_(pos, false);
            }
        }
        if (!ForgeHooks.onTravelToDimension((Entity)player, this.getCakeWorld())) {
            return InteractionResult.FAIL;
        }
        this.teleportToDimension(levelAccessor, pos, player);
        return InteractionResult.SUCCESS;
    }

    private boolean isResetItem(ItemStack stack) {
        List items = (List)TeleConfig.COMMON.resetItems.get();
        if (items == null || items.isEmpty()) {
            return false;
        }
        ResourceLocation registryLocation = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return registryLocation != null && items.contains(registryLocation.toString());
    }

    public void teleportToDimension(LevelAccessor worldIn, BlockPos pos, Player player) {
        if (player != null && !(player instanceof FakePlayer) && player.m_6084_() && !worldIn.m_5776_()) {
            ServerLevel world = ((ServerLevelAccessor)worldIn).m_6018_();
            if (!world.f_46443_ && !player.m_20159_() && !player.m_20160_() && player.m_6072_()) {
                ServerLevel destinationWorld;
                ServerPlayer playerMP = (ServerPlayer)player;
                MinecraftServer server = player.m_20194_();
                ServerLevel serverLevel = destinationWorld = server != null ? server.m_129880_(this.getCakeWorld()) : null;
                if (destinationWorld == null) {
                    player.m_213846_((Component)Component.m_237110_((String)"telepastries.pastry.custom.invalid", (Object[])new Object[]{this.getCakeWorld().m_135782_()}).m_130940_(ChatFormatting.RED));
                    TelePastries.LOGGER.error("Destination of cake invalid {} isn't known", (Object)this.getCakeWorld().m_135782_());
                    return;
                }
                CakeTeleporter cakeTeleporter = new CakeTeleporter(destinationWorld);
                CakeTeleporter.addDimensionPosition((Entity)playerMP, (ResourceKey<Level>)playerMP.m_9236_().m_46472_(), playerMP.m_20183_().m_7918_(0, 1, 0));
                playerMP.changeDimension(destinationWorld, (ITeleporter)cakeTeleporter);
            }
        }
    }

    public boolean isRefillItem(ItemStack stack) {
        return false;
    }

    public ResourceKey<Level> getCakeWorld() {
        return Level.f_46428_;
    }

    public boolean consumeCake() {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return (7 - (Integer)blockState.m_61143_((Property)BITES)) * 2;
    }

    protected void removeDimensionPosition(ServerPlayer player, ResourceKey<Level> dim) {
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = this.getTag(playerData);
        if (data.m_128441_("telepastries:" + dim.m_135782_())) {
            data.m_128473_("telepastries:" + dim.m_135782_());
            player.m_213846_((Component)Component.m_237110_((String)"telepastries.pastry.reset.complete", (Object[])new Object[]{dim.m_135782_()}));
        } else {
            player.m_213846_((Component)Component.m_237110_((String)"telepastries.pastry.reset.failed", (Object[])new Object[]{dim.m_135782_()}));
        }
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    protected CompoundTag getTag(CompoundTag tag) {
        if (tag == null || !tag.m_128441_("PlayerPersisted")) {
            return new CompoundTag();
        }
        return tag.m_128469_("PlayerPersisted");
    }
}

