/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.generator;

import com.mrbysco.telepastries.blocks.cake.BlockCakeBase;
import com.mrbysco.telepastries.init.TeleRegistry;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PastriesGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new PastryBlockStates(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new PastryItemModels(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(TeleBlocks::new, LootContextParamSets.f_81421_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationresults) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationresults, (ResourceLocation)name, (LootTable)table));
        }

        private static class TeleBlocks
        extends BlockLootSubProvider {
            protected TeleBlocks() {
                super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            }

            protected void m_245660_() {
                for (RegistryObject blockObject : TeleRegistry.BLOCKS.getEntries()) {
                    this.m_247577_((Block)blockObject.get(), TeleBlocks.m_246386_());
                }
            }

            protected Iterable<Block> getKnownBlocks() {
                return TeleRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class PastryBlockStates
    extends BlockStateProvider {
        public PastryBlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "telepastries", helper);
        }

        protected void registerStatesAndModels() {
            this.makeCake((Block)TeleRegistry.OVERWORLD_CAKE.get(), "overworld");
            this.makeCake((Block)TeleRegistry.NETHER_CAKE.get(), "nether");
            this.makeCake((Block)TeleRegistry.END_CAKE.get(), "end");
            this.makeCake((Block)TeleRegistry.TWILIGHT_CAKE.get(), "twilight");
            this.makeCake((Block)TeleRegistry.LOST_CITY_CAKE.get(), "cities");
            this.makeCake((Block)TeleRegistry.CUSTOM_CAKE.get(), "custom");
            this.makeCake((Block)TeleRegistry.CUSTOM_CAKE2.get(), "custom");
            this.makeCake((Block)TeleRegistry.CUSTOM_CAKE3.get(), "custom");
        }

        private void makeCake(Block block, String dimension) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side");
            ModelBuilder modelSlice1 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice1")).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake_slice1")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side")).texture("inside", "block/" + dimension + "/cake_inner");
            ModelBuilder modelSlice2 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice2")).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake_slice2")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side")).texture("inside", "block/" + dimension + "/cake_inner");
            ModelBuilder modelSlice36 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice3")).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake_slice3")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side")).texture("inside", "block/" + dimension + "/cake_inner");
            ModelBuilder modelSlice4 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice4")).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake_slice4")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side")).texture("inside", "block/" + dimension + "/cake_inner");
            ModelBuilder modelSlice5 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice5")).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake_slice5")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side")).texture("inside", "block/" + dimension + "/cake_inner");
            ModelBuilder modelSlice6 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice6")).renderType("cutout")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cake_slice6")))).texture("particle", "block/" + dimension + "/cake_side")).texture("bottom", "block/" + dimension + "/cake_bottom")).texture("top", "block/" + dimension + "/cake_top")).texture("side", "block/" + dimension + "/cake_side")).texture("inside", "block/" + dimension + "/cake_inner");
            this.getVariantBuilder(block).forAllStates(arg_0 -> this.lambda$makeCake$0((ModelFile)model, block, arg_0));
        }

        private /* synthetic */ ConfiguredModel[] lambda$makeCake$0(ModelFile model, Block block, BlockState state) {
            int bites = (Integer)state.m_61143_((Property)BlockCakeBase.BITES);
            boolean untouched = bites == 0;
            return ConfiguredModel.builder().modelFile((ModelFile)(untouched ? model : this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_slice" + bites))).build();
        }
    }

    private static class PastryItemModels
    extends ItemModelProvider {
        public PastryItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "telepastries", helper);
        }

        protected void registerModels() {
            TeleRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(item -> {
                String path = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
                this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
            });
        }
    }
}

