/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.util;

import com.mrbysco.telepastries.TelePastries;
import com.mrbysco.telepastries.blocks.cake.BlockCakeBase;
import com.mrbysco.telepastries.config.TeleConfig;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.ModList;

public class CakeTeleporter
implements ITeleporter {
    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = CakeTeleporter.placeNearExistingCake(destWorld, entity, this.dimensionPosition(entity, (Level)destWorld), entity instanceof Player);
        pos = CakeTeleporter.customCompat(destWorld, new BlockPos(pos.f_77676_), entity);
        pos = CakeTeleporter.moveToSafeCoords(destWorld, entity, pos != null ? new BlockPos(pos.f_77676_) : this.dimensionPosition(entity, (Level)destWorld));
        return pos;
    }

    @Nullable
    private static PortalInfo placeNearExistingCake(ServerLevel destWorld, Entity entity, BlockPos pos, boolean isPlayer) {
        boolean isFromEnd;
        int i = 200;
        BlockPos blockpos = pos;
        boolean isToEnd = destWorld.m_46472_() == Level.f_46430_;
        boolean isToOverworld = destWorld.m_46472_() == Level.f_46428_;
        boolean bl = isFromEnd = entity.f_19853_.m_46472_() == Level.f_46430_ && isToOverworld;
        if (isToEnd) {
            ServerLevel.m_8617_((ServerLevel)destWorld);
            blockpos = ServerLevel.f_8562_;
            return new PortalInfo(new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
        }
        blockpos = CakeTeleporter.getDimensionPosition(entity, (ResourceKey<Level>)destWorld.m_46472_(), entity.m_20183_());
        if (blockpos == null) {
            if (isFromEnd && isToOverworld) {
                TelePastries.LOGGER.info("Couldn't locate a cake location, using spawn point instead");
                blockpos = destWorld.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destWorld.m_220360_());
                if (isPlayer && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    BlockPos respawnPos = serverPlayer.m_8961_();
                    float respawnAngle = serverPlayer.m_8962_();
                    Optional optional = serverPlayer != null && respawnPos != null ? Player.m_36130_((ServerLevel)destWorld, (BlockPos)respawnPos, (float)respawnAngle, (boolean)false, (boolean)false) : Optional.empty();
                    if (optional.isPresent()) {
                        float f1;
                        BlockState blockstate = destWorld.m_8055_(respawnPos);
                        boolean blockIsRespawnAnchor = blockstate.m_60713_(Blocks.f_50724_);
                        Vec3 vector3d = (Vec3)optional.get();
                        if (!blockstate.m_204336_(BlockTags.f_13038_) && !blockIsRespawnAnchor) {
                            f1 = respawnAngle;
                        } else {
                            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)respawnPos).m_82546_(vector3d).m_82541_();
                            f1 = (float)Mth.m_14175_((double)(Mth.m_14136_((double)vector3d1.f_82481_, (double)vector3d1.f_82479_) * 57.2957763671875 - 90.0));
                        }
                        float angle = f1;
                        blockpos = new BlockPos(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
                        return new PortalInfo(new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5), entity.m_20184_(), angle, entity.m_146909_());
                    }
                }
            } else {
                blockpos = entity.m_20183_();
            }
        }
        if (blockpos.equals((Object)BlockPos.f_121853_)) {
            return null;
        }
        return CakeTeleporter.makePortalInfo(entity, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    private BlockPos dimensionPosition(Entity entity, Level destWorld) {
        boolean flag2;
        boolean bl = flag2 = destWorld.m_46472_() == Level.f_46429_;
        if (entity.f_19853_.m_46472_() != Level.f_46429_ && !flag2) {
            return entity.m_20183_();
        }
        WorldBorder worldborder = destWorld.m_6857_();
        double d0 = Math.max(-2.9999872E7, worldborder.m_61955_() + 16.0);
        double d1 = Math.max(-2.9999872E7, worldborder.m_61956_() + 16.0);
        double d2 = Math.min(2.9999872E7, worldborder.m_61957_() - 16.0);
        double d3 = Math.min(2.9999872E7, worldborder.m_61958_() - 16.0);
        double d4 = DimensionType.m_63908_((DimensionType)entity.f_19853_.m_6042_(), (DimensionType)destWorld.m_6042_());
        BlockPos blockpos1 = new BlockPos(Mth.m_14008_((double)(entity.m_20185_() * d4), (double)d0, (double)d2), entity.m_20186_(), Mth.m_14008_((double)(entity.m_20189_() * d4), (double)d1, (double)d3));
        return blockpos1;
    }

    public CakeTeleporter(ServerLevel worldIn) {
    }

    public Entity placeEntity(Entity newEntity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        newEntity.f_19789_ = 0.0f;
        if (newEntity instanceof LivingEntity) {
            ((LivingEntity)newEntity).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 200, false, false));
        }
        return repositionEntity.apply(false);
    }

    public static void addDimensionPosition(Entity entityIn, ResourceKey<Level> dim, BlockPos position) {
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleporter.getTag(entityData);
        ResourceLocation dimLocation = dim.m_135782_();
        if (dim == Level.f_46430_) {
            BlockPos spawnPlatform = ServerLevel.f_8562_;
            TelePastries.LOGGER.debug("Setting {}'s position of {} to: {}", new Object[]{entityIn.m_5446_().m_214077_(), dimLocation, spawnPlatform});
            data.m_128356_("telepastries:" + dimLocation, spawnPlatform.m_121878_());
        } else {
            TelePastries.LOGGER.debug("Setting {}'s position of {} to: {}", new Object[]{entityIn.m_5446_().m_214077_(), dimLocation, position});
            data.m_128356_("telepastries:" + dimLocation, position.m_121878_());
        }
        entityData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static BlockPos getDimensionPosition(Entity entityIn, ResourceKey<Level> dim, BlockPos position) {
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleporter.getTag(entityData);
        ResourceLocation dimLocation = dim.m_135782_();
        BlockPos dimPos = null;
        if (data.m_128441_("telepastries:" + dimLocation)) {
            dimPos = BlockPos.m_122022_((long)data.m_128454_("telepastries:" + dimLocation));
            TelePastries.LOGGER.debug("Found {}'s position of {} to: {}", new Object[]{entityIn.m_5446_().m_214077_(), dimLocation, dimPos});
            return dimPos;
        }
        TelePastries.LOGGER.debug("Could not find {}'s previous location. Using current location", (Object)entityIn.m_5446_().m_214077_());
        return dimPos;
    }

    public static boolean hasDimensionPosition(Entity entityIn, ResourceKey<Level> dim) {
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleporter.getTag(entityData);
        TelePastries.LOGGER.debug("Checking if entity has position stored for : " + dim.m_135782_());
        return data.m_128441_("telepastries:" + dim.m_135782_());
    }

    private static CompoundTag getTag(CompoundTag tag) {
        if (tag == null || !tag.m_128441_("PlayerPersisted")) {
            return new CompoundTag();
        }
        return tag.m_128469_("PlayerPersisted");
    }

    private static PortalInfo customCompat(ServerLevel destWorld, BlockPos pos, Entity entity) {
        ResourceLocation customLocation3;
        ResourceLocation customLocation2;
        ResourceLocation customLocation;
        ServerPlayer playerMP;
        BlockPos blockpos = pos;
        if (ModList.get().isLoaded("twilightforest")) {
            ResourceKey twilightKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("twilightforest", "twilight_forest"));
            if (destWorld.m_46472_() == twilightKey && entity instanceof ServerPlayer) {
                playerMP = (ServerPlayer)entity;
                playerMP.m_9158_(twilightKey, pos, playerMP.m_146908_(), true, false);
            }
        }
        if (ModList.get().isLoaded("lostcities")) {
            ResourceKey lostCityKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("lostcities", "lostcity"));
            if (destWorld.m_46472_() == lostCityKey && entity instanceof ServerPlayer) {
                playerMP = (ServerPlayer)entity;
                playerMP.m_9158_(lostCityKey, pos, playerMP.m_146908_(), true, false);
            }
        }
        if ((customLocation = ResourceLocation.m_135820_((String)((String)TeleConfig.COMMON.customCakeDimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)customLocation);
            if (destWorld.m_46472_() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCakeMinY.get();
                if (blockpos.m_123342_() < minY) {
                    blockpos = new BlockPos(blockpos.m_123341_(), minY, blockpos.m_123343_());
                }
                int maxY = (Integer)TeleConfig.COMMON.customCakeMaxY.get();
                if (blockpos.m_123342_() > maxY) {
                    blockpos = new BlockPos(blockpos.m_123341_(), maxY, blockpos.m_123343_());
                }
                return CakeTeleporter.makePortalInfo(entity, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            }
        }
        if ((customLocation2 = ResourceLocation.m_135820_((String)((String)TeleConfig.COMMON.customCake2Dimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)customLocation2);
            if (destWorld.m_46472_() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCake2MinY.get();
                if (blockpos.m_123342_() < minY) {
                    blockpos = new BlockPos(blockpos.m_123341_(), minY, blockpos.m_123343_());
                }
                int maxY = (Integer)TeleConfig.COMMON.customCake2MaxY.get();
                if (blockpos.m_123342_() > maxY) {
                    blockpos = new BlockPos(blockpos.m_123341_(), maxY, blockpos.m_123343_());
                }
                return CakeTeleporter.makePortalInfo(entity, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            }
        }
        if ((customLocation3 = ResourceLocation.m_135820_((String)((String)TeleConfig.COMMON.customCake3Dimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)customLocation3);
            if (destWorld.m_46472_() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCake3MinY.get();
                if (blockpos.m_123342_() < minY) {
                    blockpos = new BlockPos(blockpos.m_123341_(), minY, blockpos.m_123343_());
                }
                int maxY = (Integer)TeleConfig.COMMON.customCake3MaxY.get();
                if (blockpos.m_123342_() > maxY) {
                    blockpos = new BlockPos(blockpos.m_123341_(), maxY, blockpos.m_123343_());
                }
                return CakeTeleporter.makePortalInfo(entity, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            }
        }
        return CakeTeleporter.makePortalInfo(entity, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    private static PortalInfo moveToSafeCoords(ServerLevel world, Entity entity, BlockPos pos) {
        if (world.m_46859_(pos.m_7495_())) {
            int distance;
            for (distance = 1; world.m_8055_(pos.m_6625_(distance)).m_60734_().m_5568_() && distance < 32; ++distance) {
            }
            if (distance > 4) {
                CakeTeleporter.makePlatform(world, pos);
            }
        } else {
            if (world.m_8055_(pos.m_7494_()).m_60734_().m_5568_() && world.m_8055_(pos.m_6630_(1)).m_60734_().m_5568_()) {
                BlockPos abovePos = pos.m_6630_(1);
                return CakeTeleporter.makePortalInfo(entity, (double)abovePos.m_123341_() + 0.5, abovePos.m_123342_(), (double)abovePos.m_123343_() + 0.5);
            }
            if (!world.m_46859_(pos.m_7495_()) || !world.m_46859_(pos)) {
                CakeTeleporter.makePlatform(world, pos);
            }
        }
        return CakeTeleporter.makePortalInfo(entity, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    private static void makePlatform(ServerLevel world, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_() - 2;
        int k = pos.m_123343_();
        BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 4), (int)(k + 2)).forEach(blockPos -> {
            if (!(world.m_8055_(blockPos).m_60734_() instanceof BlockCakeBase || world.m_6425_(blockPos).m_76178_() && !(world.m_8055_(blockPos).m_60800_((BlockGetter)world, blockPos) >= 0.0f))) {
                world.m_46597_(blockPos, Blocks.f_50652_.m_49966_());
            }
        });
        BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 3), (int)(k + 1)).forEach(blockPos -> {
            if (!(world.m_8055_(blockPos).m_60734_() instanceof BlockCakeBase) && world.m_8055_(blockPos).m_60800_((BlockGetter)world, blockPos) >= 0.0f) {
                world.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            }
        });
        BlockPos.m_121976_((int)(i - 1), (int)j, (int)(k - 1), (int)(i + 1), (int)j, (int)(k + 1)).forEach(blockPos -> {
            if (!(world.m_8055_(blockPos).m_60734_() instanceof BlockCakeBase) && world.m_8055_(blockPos).m_60800_((BlockGetter)world, blockPos) >= 0.0f) {
                world.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
            }
        });
    }

    private static PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return CakeTeleporter.makePortalInfo(entity, new Vec3(x, y, z));
    }

    private static PortalInfo makePortalInfo(Entity entity, Vec3 pos) {
        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }
}

