/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.AEAxisAlignedBB;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.ChargerBlockEntity;
import appeng.client.render.FacingToRotation;
import appeng.client.render.effects.LightningArcParticleData;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import appeng.util.InteractionUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChargerBlock
extends AEBaseEntityBlock<ChargerBlockEntity> {
    public ChargerBlock() {
        super(ChargerBlock.defaultProps(Material.f_76279_).m_60955_());
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 2;
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        ChargerBlockEntity tc;
        if (InteractionUtil.isInAlternateUseMode(player)) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_() && (tc = (ChargerBlockEntity)this.getBlockEntity((BlockGetter)level, pos)) != null) {
            tc.activate(player);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        ChargerBlockEntity blockEntity = (ChargerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity != null && blockEntity.isWorking()) {
            if ((double)r.m_188501_() < 0.5) {
                return;
            }
            FacingToRotation rotation = FacingToRotation.get(blockEntity.getForward(), blockEntity.getUp());
            for (int bolts = 0; bolts < 3; ++bolts) {
                float xOff = Mth.m_216283_((RandomSource)r, (float)-0.15f, (float)0.15f);
                float zOff = Mth.m_216283_((RandomSource)r, (float)-0.15f, (float)0.15f);
                Vector3f center = new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
                Vector3f origin = new Vector3f(xOff, -0.3f, zOff);
                origin.rotate((Quaternionfc)rotation.getRot());
                origin.add((Vector3fc)center);
                Vector3f target = new Vector3f(xOff, 0.3f, zOff);
                target.rotate((Quaternionfc)rotation.getRot());
                target.add((Vector3fc)center);
                if (r.m_188499_()) {
                    Vector3f tmp = target;
                    target = origin;
                    origin = tmp;
                }
                if (!AppEngClient.instance().shouldAddParticles(r)) continue;
                Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)new LightningArcParticleData(new Vec3(target)), (double)origin.x(), (double)origin.y(), (double)origin.z(), 0.0, 0.0, 0.0);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        ChargerBlockEntity blockEntity = (ChargerBlockEntity)this.getBlockEntity(level, pos);
        if (blockEntity != null) {
            double twoPixels = 0.125;
            Direction up = blockEntity.getUp();
            Direction forward = blockEntity.getForward();
            AEAxisAlignedBB bb = new AEAxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
            if (up.m_122429_() != 0) {
                bb.minX = 0.0;
                bb.maxX = 1.0;
            }
            if (up.m_122430_() != 0) {
                bb.minY = 0.0;
                bb.maxY = 1.0;
            }
            if (up.m_122431_() != 0) {
                bb.minZ = 0.0;
                bb.maxZ = 1.0;
            }
            switch (forward) {
                case DOWN: {
                    bb.maxY = 1.0;
                    break;
                }
                case UP: {
                    bb.minY = 0.0;
                    break;
                }
                case NORTH: {
                    bb.maxZ = 1.0;
                    break;
                }
                case SOUTH: {
                    bb.minZ = 0.0;
                    break;
                }
                case EAST: {
                    bb.minX = 0.0;
                    break;
                }
                case WEST: {
                    bb.maxX = 1.0;
                    break;
                }
            }
            return Shapes.m_83064_((AABB)bb.getBoundingBox());
        }
        return Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

