/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.helpers.AEMaterials;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergyCellBlock
extends AEBaseEntityBlock<EnergyCellBlockEntity> {
    public static final int MAX_FULLNESS = 4;
    public static final IntegerProperty ENERGY_STORAGE = IntegerProperty.m_61631_((String)"fullness", (int)0, (int)4);
    private final double maxPower;
    private final double chargeRate;
    private final int priority;

    public EnergyCellBlock(double maxPower, double chargeRate, int priority) {
        super(EnergyCellBlock.defaultProps(AEMaterials.GLASS));
        this.maxPower = maxPower;
        this.chargeRate = chargeRate;
        this.priority = priority;
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
        super.addToMainCreativeTab(output);
        ItemStack charged = new ItemStack((ItemLike)this, 1);
        CompoundTag tag = charged.m_41784_();
        tag.m_128347_("internalCurrentPower", this.getMaxPower());
        tag.m_128347_("internalMaxPower", this.getMaxPower());
        output.m_246342_(charged);
    }

    public double getMaxPower() {
        return this.maxPower;
    }

    public double getChargeRate() {
        return this.chargeRate;
    }

    public int getPriority() {
        return this.priority;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENERGY_STORAGE});
    }

    @Override
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        EnergyCellBlockEntity cell = (EnergyCellBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cell != null) {
            double currentPower = cell.getAECurrentPower();
            double maxPower = cell.getAEMaxPower();
            double fillFactor = currentPower / maxPower;
            return Mth.m_14107_((double)(fillFactor * 14.0)) + (currentPower > 0.0 ? 1 : 0);
        }
        return 0;
    }
}

