/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.ProgressBar;
import appeng.menu.implementations.VibrationChamberMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class VibrationChamberScreen
extends AEBaseScreen<VibrationChamberMenu> {
    private static final Blitter BURN_PROGRESS = Blitter.texture("guis/vibchamber.png").src(176, 0, 14, 13);
    private final ProgressBar generationRateBar;

    public VibrationChamberScreen(VibrationChamberMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.generationRateBar = new ProgressBar((IProgressProvider)this.f_97732_, style.getImage("generationRateBar"), ProgressBar.Direction.VERTICAL);
        this.widgets.add("generationRateBar", this.generationRateBar);
        this.addToLeftToolbar(CommonButtons.togglePowerUnit());
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        double powerPerTick = ((VibrationChamberMenu)this.f_97732_).getPowerPerTick();
        this.generationRateBar.setFullMsg((Component)Component.m_237113_((String)Platform.formatPower(powerPerTick, true)));
    }

    @Override
    public void drawFG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (((VibrationChamberMenu)this.f_97732_).getRemainingBurnTime() > 0) {
            int f = ((VibrationChamberMenu)this.f_97732_).getRemainingBurnTime() * BURN_PROGRESS.getSrcHeight() / 100;
            BURN_PROGRESS.copy().src(BURN_PROGRESS.getSrcX(), BURN_PROGRESS.getSrcY() + BURN_PROGRESS.getSrcHeight() - f, BURN_PROGRESS.getSrcWidth(), f).dest(80, 20 + BURN_PROGRESS.getSrcHeight() - f).blit(poseStack, this.m_93252_());
        }
    }
}

