/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.config.CpuSelectionMode;
import appeng.api.config.Settings;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.CraftingStatusTableRenderer;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.GuiText;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.menu.me.crafting.CraftingStatus;
import appeng.menu.me.crafting.CraftingStatusEntry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.Nullable;

public class CraftingCPUScreen<T extends CraftingCPUMenu>
extends AEBaseScreen<T> {
    private final CraftingStatusTableRenderer table = new CraftingStatusTableRenderer(this, 9, 19);
    private final Button cancel;
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private final SettingToggleButton<CpuSelectionMode> schedulingModeButton;
    private CraftingStatus status;

    public CraftingCPUScreen(T menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.cancel = this.widgets.addButton("cancel", (Component)GuiText.Cancel.text(), () -> menu.cancelCrafting());
        this.schedulingModeButton = new ServerSettingToggleButton<CpuSelectionMode>(Settings.CPU_SELECTION_MODE, CpuSelectionMode.ANY);
        if (((CraftingCPUMenu)((Object)menu)).allowConfiguration()) {
            this.addToLeftToolbar(this.schedulingModeButton);
        }
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        Component title = this.getGuiDisplayName((Component)GuiText.CraftingStatus.text());
        if (this.status != null) {
            long elapsedTime = this.status.getElapsedTime();
            double remainingItems = this.status.getRemainingItemCount();
            double startItems = this.status.getStartItemCount();
            long eta = (long)((double)elapsedTime / Math.max(1.0, startItems - remainingItems) * remainingItems);
            if (eta > 0L && !this.getVisualEntries().isEmpty()) {
                long etaInMilliseconds = TimeUnit.MILLISECONDS.convert(eta, TimeUnit.NANOSECONDS);
                String etaTimeText = DurationFormatUtils.formatDuration((long)etaInMilliseconds, (String)GuiText.ETAFormat.getLocal());
                title = title.m_6881_().m_130946_(" - " + etaTimeText);
            }
        }
        if (((CraftingCPUMenu)this.f_97732_).isCantStoreItems()) {
            title = title.m_6881_().m_130946_(" - ").m_7220_((Component)GuiText.CantStoreItems.text().m_130940_(ChatFormatting.RED));
        }
        this.setTextContent("dialog_title", title);
        int size = this.status != null ? this.status.getEntries().size() : 0;
        this.scrollbar.setRange(0, CraftingStatusTableRenderer.getScrollableRows(size), 1);
        this.schedulingModeButton.set(((CraftingCPUMenu)this.f_97732_).getSchedulingMode());
    }

    private List<CraftingStatusEntry> getVisualEntries() {
        return this.status != null ? this.status.getEntries() : Collections.emptyList();
    }

    @Override
    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float btn) {
        this.cancel.f_93623_ = !this.getVisualEntries().isEmpty();
        super.m_86412_(poseStack, mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(poseStack, offsetX, offsetY, mouseX, mouseY);
        if (this.status != null) {
            this.table.render(poseStack, mouseX, mouseY, this.status.getEntries(), this.scrollbar.getCurrentScroll());
        }
    }

    @Override
    @Nullable
    public GenericStack getStackUnderMouse(double mouseX, double mouseY) {
        GenericStack hovered = this.table.getHoveredStack();
        if (hovered != null) {
            return hovered;
        }
        return super.getStackUnderMouse(mouseX, mouseY);
    }

    public void postUpdate(CraftingStatus status) {
        LinkedHashMap<Long, CraftingStatusEntry> entries;
        if (this.status == null || status.isFullStatus()) {
            entries = new LinkedHashMap<Long, CraftingStatusEntry>();
        } else {
            entries = new LinkedHashMap(this.status.getEntries().size());
            for (CraftingStatusEntry entry : this.status.getEntries()) {
                entries.put(entry.getSerial(), entry);
            }
        }
        for (CraftingStatusEntry entry : status.getEntries()) {
            if (entry.isDeleted()) {
                entries.remove(entry.getSerial());
                continue;
            }
            CraftingStatusEntry existingEntry = (CraftingStatusEntry)entries.get(entry.getSerial());
            if (existingEntry != null) {
                entries.put(entry.getSerial(), new CraftingStatusEntry(existingEntry.getSerial(), existingEntry.getWhat(), entry.getStoredAmount(), entry.getActiveAmount(), entry.getPendingAmount()));
                continue;
            }
            entries.put(entry.getSerial(), entry);
        }
        ArrayList<CraftingStatusEntry> sortedEntries = new ArrayList<CraftingStatusEntry>(entries.values());
        this.status = new CraftingStatus(true, status.getElapsedTime(), status.getRemainingItemCount(), status.getStartItemCount(), sortedEntries);
    }
}

