/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.networktool;

import appeng.api.client.AEStackRendering;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.GuiText;
import appeng.menu.me.networktool.MachineGroup;
import appeng.menu.me.networktool.NetworkStatus;
import appeng.menu.me.networktool.NetworkStatusMenu;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class NetworkStatusScreen
extends AEBaseScreen<NetworkStatusMenu> {
    private static final int ROWS = 4;
    private static final int COLUMNS = 5;
    private static final int TABLE_X = 14;
    private static final int TABLE_Y = 41;
    private static final int CELL_WIDTH = 30;
    private static final int CELL_HEIGHT = 18;
    private NetworkStatus status = new NetworkStatus();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");

    public NetworkStatusScreen(NetworkStatusMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.addToLeftToolbar(CommonButtons.togglePowerUnit());
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.setTextContent("dialog_title", (Component)GuiText.NetworkDetails.text(this.status.getChannelsUsed()));
        this.setTextContent("stored_power", (Component)GuiText.StoredPower.text(Platform.formatPower(this.status.getStoredPower(), false)));
        this.setTextContent("max_power", (Component)GuiText.MaxPower.text(Platform.formatPower(this.status.getMaxStoredPower(), false)));
        this.setTextContent("power_input_rate", (Component)GuiText.PowerInputRate.text(Platform.formatPower(this.status.getAveragePowerInjection(), true)));
        this.setTextContent("power_usage_rate", (Component)GuiText.PowerUsageRate.text(Platform.formatPower(this.status.getAveragePowerUsage(), true)));
        this.setTextContent("channel_power_rate", (Component)GuiText.ChannelEnergyDrain.text(Platform.formatPower(this.status.getChannelPower(), true)));
    }

    @Override
    public void drawFG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        int x = 0;
        int y = 0;
        int viewStart = this.scrollbar.getCurrentScroll() * 5;
        int viewEnd = viewStart + 20;
        ArrayList<Object> tooltip = null;
        List<MachineGroup> machines = this.status.getGroupedMachines();
        for (int i = viewStart; i < Math.min(viewEnd, machines.size()); ++i) {
            MachineGroup entry = machines.get(i);
            int cellX = 14 + x * 30;
            int cellY = 41 + y * 18;
            int itemX = cellX + 30 - 17;
            int itemY = cellY + 1;
            this.drawMachineCount(poseStack, itemX, cellY, entry.getCount());
            AEStackRendering.drawInGui(Minecraft.m_91087_(), poseStack, itemX, itemY, this.m_93252_(), entry.getDisplay());
            if (this.m_6774_(cellX, cellY, 30, 18, mouseX, mouseY)) {
                tooltip = new ArrayList<Object>();
                tooltip.add(entry.getDisplay().getDisplayName());
                tooltip.add(GuiText.Installed.text(entry.getCount()));
                if (entry.getIdlePowerUsage() > 0.0) {
                    tooltip.add(GuiText.EnergyDrain.text(Platform.formatPower(entry.getIdlePowerUsage(), true)));
                }
            }
            if (++x < 5) continue;
            ++y;
            x = 0;
        }
        if (tooltip != null) {
            this.drawTooltipWithHeader(poseStack, mouseX - offsetX, mouseY - offsetY, tooltip);
        }
    }

    private void drawMachineCount(PoseStack poseStack, int x, int y, long count) {
        Object str = count >= 10000L ? Long.toString(count / 1000L) + "k" : Long.toString(count);
        float textWidth = (float)this.f_96547_.m_92895_((String)str) / 2.0f;
        Objects.requireNonNull(this.f_96547_);
        float textHeight = 9.0f / 2.0f;
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x - 1) - textWidth, (float)y + (18.0f - textHeight) / 2.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        this.f_96547_.m_92883_(poseStack, (String)str, 0.0f, 0.0f, this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB());
        poseStack.m_85849_();
    }

    public void processServerUpdate(NetworkStatus status) {
        this.status = status;
        this.setScrollBar();
    }

    private void setScrollBar() {
        int size = this.status.getGroupedMachines().size();
        int overflowRows = (size + 5 - 1) / 5 - 4;
        this.scrollbar.setRange(0, overflowRows, 1);
    }
}

