/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook;

import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.GuidePageChange;
import appeng.client.guidebook.GuideSourceWatcher;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.CategoryIndex;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.indices.PageIndex;
import appeng.client.guidebook.navigation.NavigationTree;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.util.Platform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Guide
implements PageCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Guide.class);
    private final String defaultNamespace;
    private final String folder;
    private final Map<ResourceLocation, ParsedGuidePage> developmentPages = new HashMap<ResourceLocation, ParsedGuidePage>();
    private final Map<Class<?>, PageIndex> indices;
    private NavigationTree navigationTree = new NavigationTree();
    private Map<ResourceLocation, ParsedGuidePage> pages;
    @Nullable
    private final Path developmentSourceFolder;
    @Nullable
    private final String developmentSourceNamespace;

    private Guide(String defaultNamespace, String folder, @Nullable Path developmentSourceFolder, @Nullable String developmentSourceNamespace, Map<Class<?>, PageIndex> indices) {
        this.defaultNamespace = defaultNamespace;
        this.folder = folder;
        this.developmentSourceFolder = developmentSourceFolder;
        this.developmentSourceNamespace = developmentSourceNamespace;
        this.indices = indices;
    }

    @Override
    public <T extends PageIndex> T getIndex(Class<T> indexClass) {
        PageIndex index = this.indices.get(indexClass);
        if (index == null) {
            throw new IllegalArgumentException("No index of type " + indexClass + " is registered with this guide.");
        }
        return (T)((PageIndex)indexClass.cast(index));
    }

    public static Builder builder(String defaultNamespace, String folder) {
        return new Builder(defaultNamespace, folder);
    }

    private static CompletableFuture<Minecraft> afterClientStart() {
        CompletableFuture<Minecraft> future = new CompletableFuture<Minecraft>();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(evt -> {
            CompletableFuture reload;
            Minecraft client = Minecraft.m_91087_();
            Overlay patt4177$temp = client.m_91265_();
            if (patt4177$temp instanceof LoadingOverlay) {
                LoadingOverlay loadingOverlay = (LoadingOverlay)patt4177$temp;
                reload = loadingOverlay.f_96164_.m_7237_();
            } else {
                reload = CompletableFuture.completedFuture(null);
            }
            reload.whenCompleteAsync((o, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(client);
                }
            }, (Executor)client);
        });
        return future;
    }

    private static void runDatapackReload() {
        try {
            LayeredRegistryAccess layeredAccess = RegistryLayer.m_245849_();
            PackRepository packRepository = new PackRepository(new RepositorySource[]{new ServerPacksSource()});
            packRepository.m_10506_();
            MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, packRepository.m_10525_());
            RegistryAccess.Frozen worldgenLayer = RegistryDataLoader.m_247207_((ResourceManager)resourceManager, (RegistryAccess)layeredAccess.m_246035_((Object)RegistryLayer.WORLDGEN), (List)RegistryDataLoader.f_243803_);
            layeredAccess = layeredAccess.m_247705_((Object)RegistryLayer.WORLDGEN, new RegistryAccess.Frozen[]{worldgenLayer});
            ReloadableServerResources stuff = (ReloadableServerResources)ReloadableServerResources.m_247740_((ResourceManager)resourceManager, (RegistryAccess.Frozen)layeredAccess.m_246035_((Object)RegistryLayer.RELOADABLE), (FeatureFlagSet)FeatureFlagSet.m_246902_(), (Commands.CommandSelection)Commands.CommandSelection.ALL, (int)0, (Executor)Util.m_183991_(), Runnable::run).get();
            stuff.m_206868_((RegistryAccess)layeredAccess.m_247579_());
            Platform.fallbackClientRecipeManager = stuff.m_206887_();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public ParsedGuidePage getParsedPage(ResourceLocation id) {
        if (this.pages == null) {
            LOGGER.warn("Can't get page {}. Pages not loaded yet.", (Object)id);
            return null;
        }
        return this.developmentPages.getOrDefault(id, this.pages.get(id));
    }

    @Override
    @Nullable
    public GuidePage getPage(ResourceLocation id) {
        ParsedGuidePage page = this.getParsedPage(id);
        return page != null ? PageCompiler.compile(this, page) : null;
    }

    @Override
    public byte[] loadAsset(ResourceLocation id) {
        byte[] byArray;
        block21: {
            block20: {
                if (this.developmentSourceFolder != null && id.m_135827_().equals(this.developmentSourceNamespace)) {
                    byte[] byArray2;
                    block19: {
                        Path path = this.developmentSourceFolder.resolve(id.m_135815_());
                        InputStream in2 = Files.newInputStream(path, new OpenOption[0]);
                        try {
                            byArray2 = in2.readAllBytes();
                            if (in2 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in2 != null) {
                                    try {
                                        in2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (FileNotFoundException in2) {
                                break block20;
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to open guidebook asset {}", (Object)path);
                                return null;
                            }
                        }
                        in2.close();
                    }
                    return byArray2;
                }
            }
            id = new ResourceLocation(id.m_135827_(), this.folder + "/" + id.m_135815_());
            Resource resource = Minecraft.m_91087_().m_91098_().m_213713_(id).orElse(null);
            if (resource == null) {
                return null;
            }
            InputStream input = resource.m_215507_();
            try {
                byArray = input.readAllBytes();
                if (input == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to open guidebook asset {}", (Object)id);
                    return null;
                }
            }
            input.close();
        }
        return byArray;
    }

    @Override
    public NavigationTree getNavigationTree() {
        return this.navigationTree;
    }

    @Override
    public boolean pageExists(ResourceLocation pageId) {
        return this.developmentPages.containsKey(pageId) || this.pages != null && this.pages.containsKey(pageId);
    }

    @Nullable
    public Path getDevelopmentSourcePath(ResourceLocation id) {
        Path path;
        if (this.developmentSourceFolder != null && id.m_135827_().equals(this.developmentSourceNamespace) && Files.exists(path = this.developmentSourceFolder.resolve(id.m_135815_()), new LinkOption[0])) {
            return path;
        }
        return null;
    }

    private void watchDevelopmentSources() {
        GuideSourceWatcher watcher = new GuideSourceWatcher(this.developmentSourceNamespace, this.developmentSourceFolder);
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            List<GuidePageChange> changes;
            if (evt.phase == TickEvent.Phase.START && !(changes = watcher.takeChanges()).isEmpty()) {
                this.applyChanges(changes);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(watcher::close));
        for (ParsedGuidePage page : watcher.loadAll()) {
            this.developmentPages.put(page.getId(), page);
        }
    }

    private void applyChanges(List<GuidePageChange> changes) {
        PageIndex index2;
        for (int i = 0; i < changes.size(); ++i) {
            GuidePageChange change = changes.get(i);
            ResourceLocation pageId = change.pageId();
            ParsedGuidePage oldPage = change.newPage() != null ? this.developmentPages.put(pageId, change.newPage()) : this.developmentPages.remove(pageId);
            changes.set(i, new GuidePageChange(pageId, oldPage, change.newPage()));
        }
        ArrayList<ParsedGuidePage> allPages = new ArrayList<ParsedGuidePage>(this.pages.size() + this.developmentPages.size());
        allPages.addAll(this.pages.values());
        allPages.addAll(this.developmentPages.values());
        for (PageIndex index2 : this.indices.values()) {
            if (index2.supportsUpdate()) {
                index2.update(allPages, changes);
                continue;
            }
            index2.rebuild(allPages);
        }
        this.navigationTree = this.buildNavigation();
        index2 = Minecraft.m_91087_().f_91080_;
        if (index2 instanceof GuideScreen) {
            GuideScreen guideScreen = (GuideScreen)((Object)index2);
            ResourceLocation currentPageId = guideScreen.getCurrentPageId();
            if (changes.stream().anyMatch(c -> c.pageId().equals((Object)currentPageId))) {
                guideScreen.reloadPage();
            }
        }
    }

    private NavigationTree buildNavigation() {
        if (this.developmentPages.isEmpty()) {
            return NavigationTree.build(this.pages.values());
        }
        HashMap<ResourceLocation, ParsedGuidePage> allPages = new HashMap<ResourceLocation, ParsedGuidePage>(this.pages);
        allPages.putAll(this.developmentPages);
        return NavigationTree.build(allPages.values());
    }

    private void validateAll() {
        for (Map.Entry<ResourceLocation, ParsedGuidePage> entry : this.developmentPages.entrySet()) {
            LOGGER.info("Compiling {}", (Object)entry.getKey());
            this.getPage(entry.getKey());
        }
    }

    private void registerReloadListener() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(evt -> evt.registerReloadListener((PreparableReloadListener)new ReloadListener(new ResourceLocation(this.defaultNamespace, this.folder))));
    }

    public static class Builder {
        private final String defaultNamespace;
        private final String folder;
        private final Map<Class<?>, PageIndex> indices = new IdentityHashMap();
        private boolean registerReloadListener = true;
        @Nullable
        private ResourceLocation startupPage;
        private boolean validateAtStartup;
        private Path developmentSourceFolder;
        private String developmentSourceNamespace;
        private boolean watchDevelopmentSources = true;

        private Builder(String defaultNamespace, String folder) {
            this.defaultNamespace = Objects.requireNonNull(defaultNamespace, "defaultNamespace");
            this.folder = Objects.requireNonNull(folder, folder);
            if (!ResourceLocation.m_135830_((String)(defaultNamespace + ":dummy"))) {
                throw new IllegalArgumentException("The default namespace for a guide needs to be a valid namespace");
            }
            if (!ResourceLocation.m_135830_((String)("dummy:" + folder))) {
                throw new IllegalArgumentException("The folder for a guide needs to be a valid resource location");
            }
            String startupPageProperty = String.format(Locale.ROOT, "guideDev.%s.startupPage", folder);
            try {
                this.startupPage = new ResourceLocation(System.getProperty(startupPageProperty));
            }
            catch (Exception e) {
                LOGGER.error("Specified invalid page id in system property {}", (Object)startupPageProperty);
            }
            String devSourcesFolderProperty = String.format(Locale.ROOT, "guideDev.%s.sources", folder);
            String devSourcesNamespaceProperty = String.format(Locale.ROOT, "guideDev.%s.sourcesNamespace", defaultNamespace);
            String sourceFolder = System.getProperty(devSourcesFolderProperty);
            if (sourceFolder != null) {
                this.developmentSourceFolder = Paths.get(sourceFolder, new String[0]);
                this.developmentSourceNamespace = System.getProperty(devSourcesNamespaceProperty, defaultNamespace);
            }
            this.index(new ItemIndex());
            this.index(new CategoryIndex());
        }

        public Builder registerReloadListener(boolean enable) {
            this.registerReloadListener = enable;
            return this;
        }

        public Builder startupPage(@Nullable ResourceLocation pageId) {
            this.startupPage = pageId;
            return this;
        }

        public Builder validateAllAtStartup(boolean enable) {
            this.validateAtStartup = enable;
            return this;
        }

        public Builder developmentSources(@Nullable Path folder) {
            return this.developmentSources(folder, this.defaultNamespace);
        }

        public Builder developmentSources(Path folder, String namespace) {
            this.developmentSourceFolder = folder;
            this.developmentSourceNamespace = namespace;
            return this;
        }

        public Builder watchDevelopmentSources(boolean enable) {
            this.watchDevelopmentSources = enable;
            return this;
        }

        public Builder index(PageIndex index) {
            this.indices.put(index.getClass(), index);
            return this;
        }

        public <T extends PageIndex> Builder index(Class<? super T> clazz, T index) {
            this.indices.put(clazz, index);
            return this;
        }

        public Guide build() {
            Guide guide = new Guide(this.defaultNamespace, this.folder, this.developmentSourceFolder, this.developmentSourceNamespace, this.indices);
            if (this.registerReloadListener) {
                guide.registerReloadListener();
            }
            if (this.developmentSourceFolder != null && this.watchDevelopmentSources) {
                guide.watchDevelopmentSources();
            }
            if (this.validateAtStartup || this.startupPage != null) {
                CompletionStage reloadFuture = Guide.afterClientStart().thenRun(Guide::runDatapackReload);
                if (this.validateAtStartup) {
                    reloadFuture = ((CompletableFuture)reloadFuture).thenRun(guide::validateAll);
                }
                if (this.startupPage != null) {
                    reloadFuture = ((CompletableFuture)reloadFuture).thenRun(() -> {
                        Minecraft client = Minecraft.m_91087_();
                        client.m_91152_((Screen)GuideScreen.openNew(guide, PageAnchor.page(this.startupPage)));
                    });
                }
                ((CompletableFuture)reloadFuture).whenComplete((unused, throwable) -> {
                    if (throwable != null) {
                        LOGGER.error("Failed Guide startup.", throwable);
                    }
                });
            }
            return guide;
        }
    }

    private class ReloadListener
    extends SimplePreparableReloadListener<Map<ResourceLocation, ParsedGuidePage>> {
        private final ResourceLocation id;

        public ReloadListener(ResourceLocation id) {
            this.id = id;
        }

        protected Map<ResourceLocation, ParsedGuidePage> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            profiler.m_7242_();
            HashMap<ResourceLocation, ParsedGuidePage> pages = new HashMap<ResourceLocation, ParsedGuidePage>();
            Map resources = resourceManager.m_214159_(Guide.this.folder, location -> location.m_135815_().endsWith(".md"));
            for (Map.Entry entry : resources.entrySet()) {
                ResourceLocation pageId = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), ((ResourceLocation)entry.getKey()).m_135815_().substring((Guide.this.folder + "/").length()));
                String sourcePackId = ((Resource)entry.getValue()).m_215506_();
                try {
                    InputStream in = ((Resource)entry.getValue()).m_215507_();
                    try {
                        pages.put(pageId, PageCompiler.parse(sourcePackId, pageId, in));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load guidebook page {} from pack {}", new Object[]{pageId, sourcePackId, e});
                }
            }
            profiler.m_7241_();
            return pages;
        }

        protected void apply(Map<ResourceLocation, ParsedGuidePage> pages, ResourceManager resourceManager, ProfilerFiller profiler) {
            profiler.m_7242_();
            Guide.this.pages = pages;
            profiler.m_6180_("indices");
            ArrayList<ParsedGuidePage> allPages = new ArrayList<ParsedGuidePage>();
            allPages.addAll(pages.values());
            allPages.addAll(Guide.this.developmentPages.values());
            for (PageIndex index : Guide.this.indices.values()) {
                index.rebuild(allPages);
            }
            profiler.m_7238_();
            profiler.m_6180_("navigation");
            Guide.this.navigationTree = Guide.this.buildNavigation();
            profiler.m_7238_();
            profiler.m_7241_();
        }

        public String m_7812_() {
            return this.id.toString();
        }
    }
}

