/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.document.LytErrorSink;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public final class MdxAttrs {
    private MdxAttrs() {
    }

    @Nullable
    public static Pair<ResourceLocation, Item> getRequiredItemAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        ResourceLocation itemId;
        String id = el.getAttributeString(attribute, null);
        if (id == null) {
            errorSink.appendError(compiler, "Missing " + attribute + " attribute.", el);
            return null;
        }
        id = id.trim();
        try {
            itemId = compiler.resolveId(id);
        }
        catch (ResourceLocationException e) {
            errorSink.appendError(compiler, "Malformed item id " + id + ": " + e.getMessage(), el);
            return null;
        }
        Item resultItem = BuiltInRegistries.f_257033_.m_6612_(itemId).orElse(null);
        if (resultItem == null) {
            errorSink.appendError(compiler, "Missing item: " + itemId, el);
            return null;
        }
        return Pair.of((Object)itemId, (Object)resultItem);
    }

    public static Item getRequiredItem(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        Pair<ResourceLocation, Item> result = MdxAttrs.getRequiredItemAndId(compiler, errorSink, el, attribute);
        if (result != null) {
            return (Item)result.getRight();
        }
        return null;
    }
}

