/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.navigation;

import appeng.client.guidebook.compiler.FrontmatterNavigation;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.navigation.NavigationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationTree.class);
    private final Map<ResourceLocation, NavigationNode> nodeIndex;
    private final List<NavigationNode> rootNodes;
    private static final Comparator<NavigationNode> NODE_COMPARATOR = Comparator.comparingInt(NavigationNode::position).thenComparing(NavigationNode::title);

    public NavigationTree(Map<ResourceLocation, NavigationNode> nodeIndex, List<NavigationNode> rootNodes) {
        this.nodeIndex = nodeIndex;
        this.rootNodes = rootNodes;
    }

    public NavigationTree() {
        this.nodeIndex = Map.of();
        this.rootNodes = List.of();
    }

    public List<NavigationNode> getRootNodes() {
        return this.rootNodes;
    }

    @Nullable
    public NavigationNode getNodeById(ResourceLocation pageId) {
        return this.nodeIndex.get(pageId);
    }

    public static NavigationTree build(Collection<ParsedGuidePage> pages) {
        HashMap<ResourceLocation, Pair<ParsedGuidePage, List<ParsedGuidePage>>> pagesWithChildren = new HashMap<ResourceLocation, Pair<ParsedGuidePage, List<ParsedGuidePage>>>();
        for (ParsedGuidePage page : pages) {
            FrontmatterNavigation navigationEntry = page.getFrontmatter().navigationEntry();
            if (navigationEntry == null) continue;
            pagesWithChildren.compute(page.getId(), (resourceLocation, previousPair) -> previousPair != null ? Pair.of((Object)page, (Object)((List)previousPair.getRight())) : Pair.of((Object)page, new ArrayList()));
            ResourceLocation parentId = navigationEntry.parent();
            if (parentId == null) continue;
            pagesWithChildren.compute(parentId, (resourceLocation, prevPage) -> {
                if (prevPage != null) {
                    ((List)prevPage.getRight()).add(page);
                    return prevPage;
                }
                ArrayList<ParsedGuidePage> children = new ArrayList<ParsedGuidePage>();
                children.add(page);
                return Pair.of(null, children);
            });
        }
        HashMap<ResourceLocation, NavigationNode> nodeIndex = new HashMap<ResourceLocation, NavigationNode>(pages.size());
        ArrayList<NavigationNode> rootNodes = new ArrayList<NavigationNode>();
        for (Map.Entry entry : pagesWithChildren.entrySet()) {
            NavigationTree.createNode(nodeIndex, rootNodes, pagesWithChildren, (ResourceLocation)entry.getKey(), (Pair<ParsedGuidePage, List<ParsedGuidePage>>)((Pair)entry.getValue()));
        }
        rootNodes.sort(NODE_COMPARATOR);
        return new NavigationTree(Map.copyOf(nodeIndex), List.copyOf(rootNodes));
    }

    private static NavigationNode createNode(HashMap<ResourceLocation, NavigationNode> nodeIndex, ArrayList<NavigationNode> rootNodes, Map<ResourceLocation, Pair<ParsedGuidePage, List<ParsedGuidePage>>> pagesWithChildren, ResourceLocation pageId, Pair<ParsedGuidePage, List<ParsedGuidePage>> entry) {
        ParsedGuidePage page = (ParsedGuidePage)entry.getKey();
        List children = (List)entry.getRight();
        if (page == null) {
            LOGGER.error("Pages {} had unknown navigation parent {}", (Object)children, (Object)pageId);
            return null;
        }
        FrontmatterNavigation navigationEntry = Objects.requireNonNull(page.getFrontmatter().navigationEntry(), "navigation frontmatter");
        ItemStack icon = ItemStack.f_41583_;
        if (navigationEntry.iconItemId() != null) {
            Item iconItem = (Item)BuiltInRegistries.f_257033_.m_7745_(navigationEntry.iconItemId());
            icon = new ItemStack((ItemLike)iconItem);
            icon.m_41751_(navigationEntry.iconNbt());
            if (icon.m_41619_()) {
                LOGGER.error("Couldn't find icon {} for icon of page {}", (Object)navigationEntry.iconItemId(), (Object)page);
            }
        }
        ArrayList<NavigationNode> childNodes = new ArrayList<NavigationNode>(children.size());
        for (ParsedGuidePage childPage : children) {
            Pair<ParsedGuidePage, List<ParsedGuidePage>> childPageEntry = pagesWithChildren.get(childPage.getId());
            childNodes.add(NavigationTree.createNode(nodeIndex, rootNodes, pagesWithChildren, childPage.getId(), childPageEntry));
        }
        childNodes.sort(NODE_COMPARATOR);
        NavigationNode node = new NavigationNode(page.getId(), navigationEntry.title(), icon, childNodes, navigationEntry.position(), true);
        nodeIndex.put(page.getId(), node);
        if (navigationEntry.parent() == null) {
            rootNodes.add(node);
        }
        return node;
    }
}

