/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BlockEntityRenderHelper {
    public static byte findSpin(Direction facing, Direction up) {
        Direction currentUp = switch (facing) {
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            default -> Direction.UP;
        };
        for (byte spin = 0; spin < 4; spin = (byte)(spin + 1)) {
            if (currentUp == up) {
                return spin;
            }
            currentUp = Platform.rotateAround(currentUp, facing);
        }
        return 0;
    }

    public static void rotateToFace(PoseStack mStack, Direction face, byte spin) {
        switch (face) {
            case UP: {
                mStack.m_252781_(new Quaternionf().rotationX(4.712389f));
                break;
            }
            case DOWN: {
                mStack.m_252781_(new Quaternionf().rotationX(1.5707964f));
                break;
            }
            case EAST: {
                mStack.m_252781_(new Quaternionf().rotationY(1.5707964f));
                break;
            }
            case WEST: {
                mStack.m_252781_(new Quaternionf().rotationY(-1.5707964f));
                break;
            }
            case NORTH: {
                mStack.m_252781_(new Quaternionf().rotationY((float)Math.PI));
                break;
            }
        }
        mStack.m_85850_().m_252922_().rotate((Quaternionfc)new Quaternionf().rotationZ((float)Math.PI / 180 * (float)(-spin) * 90.0f));
    }

    public static void renderItem2d(PoseStack poseStack, MultiBufferSource buffers, AEKey what, float scale, int combinedLightIn) {
        AEStackRendering.drawOnBlockFace(poseStack, buffers, what, scale, combinedLightIn);
    }

    public static void renderItem2dWithAmount(PoseStack poseStack, MultiBufferSource buffers, AEKey what, long amount, float itemScale, float spacing, int textColor) {
        BlockEntityRenderHelper.renderItem2d(poseStack, buffers, what, itemScale, 0xF000F0);
        String renderedStackSize = what.formatAmount(amount, AmountFormat.SLOT);
        Font fr = Minecraft.m_91087_().f_91062_;
        int width = fr.m_92895_(renderedStackSize);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, spacing, 0.02f);
        poseStack.m_85841_(0.016129032f, -0.016129032f, 0.016129032f);
        poseStack.m_85841_(0.5f, 0.5f, 0.0f);
        poseStack.m_252880_(-0.5f * (float)width, 0.0f, 0.5f);
        fr.m_252905_(renderedStackSize, 0.0f, 0.0f, textColor, false, poseStack.m_85850_().m_252922_(), buffers, false, 0, 0xF000F0);
        poseStack.m_85849_();
    }
}

