/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public enum FacingToRotation implements StringRepresentable
{
    DOWN_DOWN(new Vector3f(0.0f, 0.0f, 0.0f)),
    DOWN_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    DOWN_NORTH(new Vector3f(-90.0f, 0.0f, 0.0f)),
    DOWN_SOUTH(new Vector3f(-90.0f, 0.0f, 180.0f)),
    DOWN_WEST(new Vector3f(-90.0f, 0.0f, 90.0f)),
    DOWN_EAST(new Vector3f(-90.0f, 0.0f, -90.0f)),
    UP_DOWN(new Vector3f(0.0f, 0.0f, 0.0f)),
    UP_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    UP_NORTH(new Vector3f(90.0f, 0.0f, 180.0f)),
    UP_SOUTH(new Vector3f(90.0f, 0.0f, 0.0f)),
    UP_WEST(new Vector3f(90.0f, 0.0f, 90.0f)),
    UP_EAST(new Vector3f(90.0f, 0.0f, -90.0f)),
    NORTH_DOWN(new Vector3f(0.0f, 0.0f, 180.0f)),
    NORTH_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_NORTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_SOUTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_WEST(new Vector3f(0.0f, 0.0f, 90.0f)),
    NORTH_EAST(new Vector3f(0.0f, 0.0f, -90.0f)),
    SOUTH_DOWN(new Vector3f(0.0f, 180.0f, 180.0f)),
    SOUTH_UP(new Vector3f(0.0f, 180.0f, 0.0f)),
    SOUTH_NORTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH_SOUTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH_WEST(new Vector3f(0.0f, 180.0f, -90.0f)),
    SOUTH_EAST(new Vector3f(0.0f, 180.0f, 90.0f)),
    WEST_DOWN(new Vector3f(0.0f, 90.0f, 180.0f)),
    WEST_UP(new Vector3f(0.0f, 90.0f, 0.0f)),
    WEST_NORTH(new Vector3f(0.0f, 90.0f, -90.0f)),
    WEST_SOUTH(new Vector3f(0.0f, 90.0f, 90.0f)),
    WEST_WEST(new Vector3f(0.0f, 0.0f, 0.0f)),
    WEST_EAST(new Vector3f(0.0f, 0.0f, 0.0f)),
    EAST_DOWN(new Vector3f(0.0f, -90.0f, 180.0f)),
    EAST_UP(new Vector3f(0.0f, -90.0f, 0.0f)),
    EAST_NORTH(new Vector3f(0.0f, -90.0f, 90.0f)),
    EAST_SOUTH(new Vector3f(0.0f, -90.0f, -90.0f)),
    EAST_WEST(new Vector3f(0.0f, 0.0f, 0.0f)),
    EAST_EAST(new Vector3f(0.0f, 0.0f, 0.0f));

    private final Vector3f rot;
    private final Quaternionf xRot;
    private final Quaternionf yRot;
    private final Quaternionf zRot;
    private final Quaternionf combinedRotation;
    private final Matrix4f mat;

    private FacingToRotation(Vector3f rot) {
        this.rot = rot;
        this.xRot = new Quaternionf().rotateX(rot.x() * ((float)Math.PI / 180));
        this.yRot = new Quaternionf().rotateY(rot.y() * ((float)Math.PI / 180));
        this.zRot = new Quaternionf().rotateZ(rot.z() * ((float)Math.PI / 180));
        this.mat = new Matrix4f().rotationXYZ(rot.x() * ((float)Math.PI / 180), rot.y() * ((float)Math.PI / 180), rot.z() * ((float)Math.PI / 180));
        this.combinedRotation = new Quaternionf().rotateXYZ(rot.x() * ((float)Math.PI / 180), rot.y() * ((float)Math.PI / 180), rot.z() * ((float)Math.PI / 180));
    }

    public boolean isRedundant() {
        return this.rot.x() == 0.0f && this.rot.y() == 0.0f && this.rot.z() == 0.0f;
    }

    public Quaternionf getRot() {
        return this.combinedRotation;
    }

    public Matrix4f getMat() {
        return new Matrix4f((Matrix4fc)this.mat);
    }

    public void push(PoseStack mStack) {
        mStack.m_252781_(this.xRot);
        mStack.m_252781_(this.yRot);
        mStack.m_252781_(this.zRot);
    }

    public Direction rotate(Direction facing) {
        Vec3i dir = facing.m_122436_();
        Vector4f vec = new Vector4f((float)dir.m_123341_(), (float)dir.m_123342_(), (float)dir.m_123343_(), 1.0f);
        this.mat.transform(vec);
        return Direction.m_122372_((float)vec.x(), (float)vec.y(), (float)vec.z());
    }

    public Direction resultingRotate(Direction facing) {
        if (facing == null) {
            return null;
        }
        for (Direction face : Direction.values()) {
            if (this.rotate(face) != facing) continue;
            return face;
        }
        return null;
    }

    public static FacingToRotation get(Direction forward, Direction up) {
        return FacingToRotation.values()[forward.ordinal() * 6 + up.ordinal()];
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

