/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.client.render.FacingToRotation;
import appeng.thirdparty.fabric.MutableQuadView;
import appeng.thirdparty.fabric.RenderContext;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.EnumMap;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Direction;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class QuadRotator
implements RenderContext.QuadTransform {
    public static final RenderContext.QuadTransform NULL_TRANSFORM = quad -> true;
    private static final EnumMap<FacingToRotation, RenderContext.QuadTransform> TRANSFORMS = new EnumMap(FacingToRotation.class);
    private final FacingToRotation rotation;
    private final Quaternionf quaternion;

    private QuadRotator(FacingToRotation rotation) {
        this.rotation = rotation;
        this.quaternion = rotation.getRot();
    }

    public static RenderContext.QuadTransform get(Direction newForward, Direction newUp) {
        return QuadRotator.get(QuadRotator.getRotation(newForward, newUp));
    }

    public static RenderContext.QuadTransform get(FacingToRotation rotation) {
        if (rotation.isRedundant()) {
            return NULL_TRANSFORM;
        }
        return TRANSFORMS.get((Object)rotation);
    }

    @Override
    public boolean transform(MutableQuadView quad) {
        Vector3f tmp = new Vector3f();
        for (int i = 0; i < 4; ++i) {
            quad.copyPos(i, tmp);
            tmp.add(-0.5f, -0.5f, -0.5f);
            tmp.rotate((Quaternionfc)this.quaternion);
            tmp.add(0.5f, 0.5f, 0.5f);
            quad.pos(i, tmp);
            if (!quad.hasNormal(i)) continue;
            quad.copyNormal(i, tmp);
            tmp.rotate((Quaternionfc)this.quaternion);
            quad.normal(i, tmp);
        }
        Direction nominalFace = quad.nominalFace();
        Direction cullFace = quad.cullFace();
        if (cullFace != null) {
            quad.cullFace(this.rotation.rotate(cullFace));
        }
        Direction rotatedNominalFace = this.rotation.rotate(nominalFace);
        quad.nominalFace(rotatedNominalFace);
        int[] data = new int[DefaultVertexFormat.f_85811_.m_86017_() * 4];
        quad.toVanilla(0, data, 0, false);
        BlockModel.f_111421_.m_111630_(data, rotatedNominalFace);
        quad.fromVanilla(data, 0, false);
        return true;
    }

    private static FacingToRotation getRotation(Direction forward, Direction up) {
        if (forward.m_122434_() == up.m_122434_()) {
            up = up.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        }
        return FacingToRotation.get(forward, up);
    }

    static {
        for (FacingToRotation rotation : FacingToRotation.values()) {
            if (rotation.isRedundant()) {
                TRANSFORMS.put(rotation, NULL_TRANSFORM);
                continue;
            }
            TRANSFORMS.put(rotation, new QuadRotator(rotation));
        }
    }
}

