/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.DelegateBakedModel;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.AEModelData;
import appeng.client.render.model.AutoRotatingCacheKey;
import appeng.util.Platform;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class AutoRotatingBakedModel
extends DelegateBakedModel {
    private static final Direction[] CULL_FACES = (Direction[])Stream.concat(Arrays.stream(Direction.values()), Stream.of((Direction)null)).toArray(Direction[]::new);
    private final BakedModel parent;
    private final LoadingCache<AutoRotatingCacheKey, List<BakedQuad>[]> quadCache;

    public AutoRotatingBakedModel(BakedModel parent) {
        super(parent);
        this.parent = parent;
        this.quadCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<AutoRotatingCacheKey, List<BakedQuad>[]>(){

            public List<BakedQuad>[] load(AutoRotatingCacheKey key) {
                return AutoRotatingBakedModel.this.getRotatedModel(key.getBlockState(), key.getModelData());
            }
        });
    }

    private List<BakedQuad>[] getRotatedModel(BlockState state, ModelData modelData) {
        FacingToRotation f2r = FacingToRotation.get(AEModelData.getForward(modelData), AEModelData.getUp(modelData));
        RandomSource rand = RandomSource.m_216335_((long)0L);
        if (f2r.isRedundant()) {
            List[] result = new List[7];
            for (Direction value : CULL_FACES) {
                int idx = value == null ? 6 : value.ordinal();
                result[idx] = this.parent.getQuads(state, value, rand, modelData, null);
            }
            return result;
        }
        List[] quads = new List[CULL_FACES.length];
        for (int i = 0; i < CULL_FACES.length; ++i) {
            quads[i] = this.rotateQuadsFromSide(state, CULL_FACES[i], rand, modelData, f2r, null);
        }
        return quads;
    }

    @Override
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if (state == null) {
            return this.getBaseModel().m_213637_(state, side, rand);
        }
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (state == null) {
            return this.getBaseModel().getQuads(state, side, rand, modelData, renderType);
        }
        Boolean uncachable = (Boolean)modelData.get(AEModelData.SKIP_CACHE);
        if (Platform.isDevelopmentEnvironment() || Boolean.TRUE.equals(uncachable)) {
            FacingToRotation f2r = FacingToRotation.get(AEModelData.getForward(modelData), AEModelData.getUp(modelData));
            return this.rotateQuadsFromSide(state, side, rand, modelData, f2r, renderType);
        }
        int sideIdx = side == null ? 6 : side.ordinal();
        return ((List[])this.quadCache.getUnchecked((Object)new AutoRotatingCacheKey(state, modelData)))[sideIdx];
    }

    private List<BakedQuad> rotateQuadsFromSide(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, FacingToRotation f2r, @Nullable RenderType renderType) {
        Direction cullFace = f2r.resultingRotate(side);
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(this.parent.getQuads(state, cullFace, rand, modelData, renderType));
        Vector3f pos = new Vector3f();
        Quaternionf q = f2r.getRot();
        for (int i = 0; i < result.size(); ++i) {
            BakedQuad quad = result.get(i);
            int[] data = (int[])quad.m_111303_().clone();
            int VERTEX_STRIDE = DefaultVertexFormat.f_85811_.m_86017_();
            int offset = 0;
            for (int v = 0; v < 4; ++v) {
                pos.set(Float.intBitsToFloat(data[offset + 0]) - 0.5f, Float.intBitsToFloat(data[offset + 1]) - 0.5f, Float.intBitsToFloat(data[offset + 2]) - 0.5f);
                pos.rotate((Quaternionfc)q);
                data[offset + 0] = Float.floatToRawIntBits(pos.x() + 0.5f);
                data[offset + 1] = Float.floatToRawIntBits(pos.y() + 0.5f);
                data[offset + 2] = Float.floatToRawIntBits(pos.z() + 0.5f);
                offset += VERTEX_STRIDE;
            }
            Direction direction = f2r.rotate(quad.m_111306_());
            BlockModel.f_111421_.m_111630_(data, direction);
            ForgeHooksClient.fillNormal((int[])data, (Direction)direction);
            result.set(i, new BakedQuad(data, quad.m_111305_(), direction, quad.m_173410_(), quad.m_111307_(), quad.hasAmbientOcclusion()));
        }
        return result;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        return this.parent.getModelData(level, pos, state, modelData);
    }
}

