/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

class ColorApplicatorBakedModel
implements BakedModel {
    private final BakedModel baseModel;
    private final EnumMap<Direction, List<BakedQuad>> quadsBySide;
    private final List<BakedQuad> generalQuads;

    ColorApplicatorBakedModel(BakedModel baseModel, TextureAtlasSprite texDark, TextureAtlasSprite texMedium, TextureAtlasSprite texBright) {
        this.baseModel = baseModel;
        this.generalQuads = this.fixQuadTint(null, texDark, texMedium, texBright);
        this.quadsBySide = new EnumMap(Direction.class);
        for (Direction facing : Direction.values()) {
            this.quadsBySide.put(facing, this.fixQuadTint(facing, texDark, texMedium, texBright));
        }
    }

    private List<BakedQuad> fixQuadTint(Direction facing, TextureAtlasSprite texDark, TextureAtlasSprite texMedium, TextureAtlasSprite texBright) {
        List quads = this.baseModel.getQuads(null, facing, RandomSource.m_216335_((long)0L), ModelData.EMPTY, null);
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            int tint;
            if (quad.m_173410_() == texDark) {
                tint = 1;
            } else if (quad.m_173410_() == texMedium) {
                tint = 2;
            } else if (quad.m_173410_() == texBright) {
                tint = 3;
            } else {
                result.add(quad);
                continue;
            }
            BakedQuad newQuad = new BakedQuad(quad.m_111303_(), tint, quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
            result.add(newQuad);
        }
        return result;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if (side == null) {
            return this.generalQuads;
        }
        return this.quadsBySide.get(side);
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        this.baseModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
        return this;
    }
}

