/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.overlay;

import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ChunkPos;
import org.joml.Matrix4f;

public class OverlayRenderer {
    private IOverlayDataSource source;

    OverlayRenderer(IOverlayDataSource source) {
        this.source = source;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer) {
        RenderType typeFaces = OverlayRenderType.getBlockHilightFace();
        this.render(poseStack, buffer.m_6299_(typeFaces), false);
        RenderType typeLines = OverlayRenderType.getBlockHilightLine();
        this.render(poseStack, buffer.m_6299_(typeLines), true);
    }

    private void render(PoseStack poseStack, VertexConsumer builder, boolean renderLines) {
        int[] cols = OverlayRenderType.decomposeColor(this.source.getOverlayColor());
        for (ChunkPos pos : this.source.getOverlayChunks()) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos.m_45604_(), 0.0f, (float)pos.m_45605_());
            Matrix4f posMat = poseStack.m_85850_().m_252922_();
            this.addVertices(builder, posMat, pos, cols, renderLines);
            poseStack.m_85849_();
        }
    }

    private void addVertices(VertexConsumer wr, Matrix4f posMat, ChunkPos pos, int[] cols, boolean renderLines) {
        boolean noEast;
        Set<ChunkPos> chunks = this.source.getOverlayChunks();
        float x1 = 0.0f;
        float x2 = 16.0f;
        float y1 = -64.0f;
        float y2 = 256.0f;
        float z1 = 0.0f;
        float z2 = 16.0f;
        boolean noNorth = !chunks.contains(new ChunkPos(pos.f_45578_, pos.f_45579_ - 1));
        boolean noSouth = !chunks.contains(new ChunkPos(pos.f_45578_, pos.f_45579_ + 1));
        boolean noWest = !chunks.contains(new ChunkPos(pos.f_45578_ - 1, pos.f_45579_));
        boolean bl = noEast = !chunks.contains(new ChunkPos(pos.f_45578_ + 1, pos.f_45579_));
        if (noNorth) {
            wr.m_252986_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x2, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x1, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (noSouth) {
            wr.m_252986_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x1, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x2, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (noWest) {
            wr.m_252986_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            wr.m_252986_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            wr.m_252986_(posMat, x1, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            wr.m_252986_(posMat, x1, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (noEast) {
            wr.m_252986_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            wr.m_252986_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            wr.m_252986_(posMat, x2, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            wr.m_252986_(posMat, x2, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (renderLines) {
            if (noNorth || noWest) {
                wr.m_252986_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                wr.m_252986_(posMat, x1, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (noNorth || noEast) {
                wr.m_252986_(posMat, x2, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                wr.m_252986_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            }
            if (noSouth || noEast) {
                wr.m_252986_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                wr.m_252986_(posMat, x2, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (noSouth || noWest) {
                wr.m_252986_(posMat, x1, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                wr.m_252986_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            }
        } else {
            wr.m_252986_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            wr.m_252986_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        }
    }
}

