/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.blockentity.misc.CrankBlockEntity;
import appeng.client.render.FacingToRotation;
import appeng.core.AppEng;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class CrankRenderer
implements BlockEntityRenderer<CrankBlockEntity> {
    public static final ResourceLocation BASE_MODEL = AppEng.makeId("block/crank_base");
    public static final ResourceLocation HANDLE_MODEL = AppEng.makeId("block/crank_handle");
    private final BlockRenderDispatcher blockRenderer;
    private final ModelManager modelManager;

    public CrankRenderer(BlockEntityRendererProvider.Context context) {
        this.modelManager = context.m_173584_().m_110907_().m_110881_();
        this.blockRenderer = context.m_173584_();
    }

    public void render(CrankBlockEntity crank, float partialTick, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BakedModel baseModel = this.modelManager.getModel(BASE_MODEL);
        BakedModel handleModel = this.modelManager.getModel(HANDLE_MODEL);
        BlockState blockState = crank.m_58900_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        BlockPos pos = crank.m_58899_();
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        FacingToRotation.get(crank.getForward(), crank.getUp()).push(stack);
        stack.m_85837_(-0.5, -0.5, -0.5);
        this.blockRenderer.m_110937_().m_234390_((BlockAndTintGetter)crank.m_58904_(), baseModel, blockState, pos, stack, buffer, false, RandomSource.m_216327_(), blockState.m_60726_(pos), packedOverlay);
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_252781_(new Quaternionf().rotationY((float)Math.PI / 180 * crank.getVisibleRotation()));
        stack.m_85837_(-0.5, -0.5, -0.5);
        this.blockRenderer.m_110937_().m_234390_((BlockAndTintGetter)crank.m_58904_(), handleModel, blockState, pos, stack, buffer, false, RandomSource.m_216327_(), blockState.m_60726_(pos), packedOverlay);
        stack.m_85849_();
    }
}

