/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.ids.AECreativeTabIds;
import appeng.core.definitions.AEItems;
import appeng.items.parts.FacadeItem;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.CreativeModeTabEvent;

public final class FacadeItemGroup {
    private static CreativeModeTab group;

    public static void init(CreativeModeTabEvent.Register register) {
        Preconditions.checkState((group == null ? 1 : 0) != 0);
        group = register.registerCreativeModeTab(AECreativeTabIds.FACADES, builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.ae2.facades")).m_257737_(() -> {
            Collection items = group.m_260957_();
            return items.stream().findFirst().orElse(Items.f_42502_.m_7968_());
        }).m_257501_(FacadeItemGroup::buildDisplayItems).m_257652_());
    }

    public static CreativeModeTab getGroup() {
        if (group == null) {
            throw new IllegalStateException();
        }
        return group;
    }

    private static void buildDisplayItems(FeatureFlagSet featureFlagSet, CreativeModeTab.Output output, boolean opItems) {
        Set facades = ItemStackLinkedSet.m_261170_();
        FacadeItem itemFacade = AEItems.FACADE.m_5456_();
        try {
            for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
                if (tab == group) continue;
                for (ItemStack displayItem : tab.m_260957_()) {
                    ItemStack facade = itemFacade.createFacadeForItem(displayItem, false);
                    if (facade.m_41619_()) continue;
                    facades.add(facade);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        output.m_246601_((Collection)facades);
    }
}

