/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.ids.AECreativeTabIds;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.ItemDefinition;
import appeng.items.AEBaseItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.CreativeModeTabEvent;

public final class MainCreativeTab {
    private static final Multimap<CreativeModeTab, ItemDefinition<?>> externalItemDefs = HashMultimap.create();
    private static final List<ItemDefinition<?>> itemDefs = new ArrayList();
    public static CreativeModeTab INSTANCE;

    public static void init(CreativeModeTabEvent.Register register) {
        INSTANCE = register.registerCreativeModeTab(AECreativeTabIds.MAIN, builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.ae2.main")).m_257737_(() -> AEBlocks.CONTROLLER.stack(1)).m_257501_(MainCreativeTab::buildDisplayItems).m_257652_());
    }

    public static void initExternal(CreativeModeTabEvent.BuildContents contents) {
        for (ItemDefinition itemDefinition : externalItemDefs.get((Object)contents.getTab())) {
            contents.m_246326_((ItemLike)itemDefinition);
        }
    }

    public static void add(ItemDefinition<?> itemDef) {
        itemDefs.add(itemDef);
    }

    public static void addExternal(CreativeModeTab tab, ItemDefinition<?> itemDef) {
        externalItemDefs.put((Object)tab, itemDef);
    }

    private static void buildDisplayItems(FeatureFlagSet featureFlagSet, CreativeModeTab.Output output, boolean opItems) {
        for (ItemDefinition<?> itemDef : itemDefs) {
            AEBaseBlockItem baseItem;
            Block block;
            Object item = itemDef.m_5456_();
            if (item instanceof AEBaseBlockItem && (block = (baseItem = (AEBaseBlockItem)((Object)item)).m_40614_()) instanceof AEBaseBlock) {
                AEBaseBlock baseBlock = (AEBaseBlock)block;
                baseBlock.addToMainCreativeTab(output);
                continue;
            }
            if (item instanceof AEBaseItem) {
                AEBaseItem baseItem2 = (AEBaseItem)((Object)item);
                baseItem2.addToMainCreativeTab(output);
                continue;
            }
            output.m_246326_(itemDef);
        }
    }
}

