/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen;

import appeng.datagen.providers.WorldGenProvider;
import appeng.datagen.providers.advancements.AdvancementGenerator;
import appeng.datagen.providers.localization.LocalizationProvider;
import appeng.datagen.providers.loot.BlockDropProvider;
import appeng.datagen.providers.models.BlockModelProvider;
import appeng.datagen.providers.models.CableModelProvider;
import appeng.datagen.providers.models.DecorationModelProvider;
import appeng.datagen.providers.models.ItemModelProvider;
import appeng.datagen.providers.models.PartModelProvider;
import appeng.datagen.providers.recipes.ChargerRecipes;
import appeng.datagen.providers.recipes.CraftingRecipes;
import appeng.datagen.providers.recipes.DecorationBlockRecipes;
import appeng.datagen.providers.recipes.DecorationRecipes;
import appeng.datagen.providers.recipes.EntropyRecipes;
import appeng.datagen.providers.recipes.InscriberRecipes;
import appeng.datagen.providers.recipes.MatterCannonAmmoProvider;
import appeng.datagen.providers.recipes.SmeltingRecipes;
import appeng.datagen.providers.recipes.SmithingRecipes;
import appeng.datagen.providers.recipes.TransformRecipes;
import appeng.datagen.providers.tags.BiomeTagsProvider;
import appeng.datagen.providers.tags.BlockTagsProvider;
import appeng.datagen.providers.tags.FluidTagsProvider;
import appeng.datagen.providers.tags.ItemTagsProvider;
import appeng.datagen.providers.tags.PoiTypeTagsProvider;
import appeng.init.worldgen.InitBiomes;
import appeng.init.worldgen.InitDimensionTypes;
import appeng.init.worldgen.InitStructures;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="ae2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AE2DataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent dataEvent) {
        AE2DataGenerators.onGatherData(dataEvent.getGenerator(), dataEvent.getExistingFileHelper());
    }

    public static void onGatherData(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryAccess.Frozen registryAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        CompletableFuture<HolderLookup.Provider> registries = AE2DataGenerators.createAppEngProvider((RegistryAccess)registryAccess);
        LocalizationProvider localization = new LocalizationProvider(generator);
        DataGenerator.PackGenerator mainPack = generator.m_253147_(true);
        mainPack.m_253108_(AE2DataGenerators.bindRegistries(WorldGenProvider::new, registries));
        mainPack.m_253108_(BlockDropProvider::new);
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)mainPack.m_253108_(packOutput -> new BlockTagsProvider(packOutput, registries, existingFileHelper));
        mainPack.m_253108_(packOutput -> new ItemTagsProvider(packOutput, registries, (TagsProvider<Block>)blockTagsProvider, existingFileHelper));
        mainPack.m_253108_(packOutput -> new FluidTagsProvider(packOutput, registries, existingFileHelper));
        mainPack.m_253108_(packOutput -> new BiomeTagsProvider(packOutput, registries, existingFileHelper));
        mainPack.m_253108_(packOutput -> new PoiTypeTagsProvider(packOutput, registries, existingFileHelper));
        mainPack.m_253108_(packOutput -> new BlockModelProvider(packOutput, existingFileHelper));
        mainPack.m_253108_(packOutput -> new DecorationModelProvider(packOutput, existingFileHelper));
        mainPack.m_253108_(packOutput -> new ItemModelProvider(packOutput, existingFileHelper));
        mainPack.m_253108_(packOutput -> new CableModelProvider(packOutput, existingFileHelper));
        mainPack.m_253108_(packOutput -> new PartModelProvider(packOutput, existingFileHelper));
        mainPack.m_253108_(packOutput -> new AdvancementGenerator(packOutput, localization));
        mainPack.m_253108_(DecorationRecipes::new);
        mainPack.m_253108_(DecorationBlockRecipes::new);
        mainPack.m_253108_(MatterCannonAmmoProvider::new);
        mainPack.m_253108_(EntropyRecipes::new);
        mainPack.m_253108_(InscriberRecipes::new);
        mainPack.m_253108_(SmeltingRecipes::new);
        mainPack.m_253108_(CraftingRecipes::new);
        mainPack.m_253108_(SmithingRecipes::new);
        mainPack.m_253108_(TransformRecipes::new);
        mainPack.m_253108_(ChargerRecipes::new);
        mainPack.m_253108_(packOutput -> localization);
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> factory, CompletableFuture<HolderLookup.Provider> factories) {
        return packOutput -> (DataProvider)factory.apply(packOutput, factories);
    }

    private static CompletableFuture<HolderLookup.Provider> createAppEngProvider(RegistryAccess registryAccess) {
        List extensions = List.of(new LookupExtension(Registries.f_256787_, InitDimensionTypes::init), new LookupExtension(Registries.f_256944_, InitStructures::initDatagenStructures), new LookupExtension(Registries.f_256998_, InitStructures::initDatagenStructureSets), new LookupExtension(Registries.f_256952_, InitBiomes::init));
        RegistrySetBuilder builder = new RegistrySetBuilder();
        for (RegistrySetBuilder.RegistryStub entry : VanillaRegistries.f_254635_.f_254732_) {
            LookupExtension extension = extensions.stream().filter(e -> e.key() == entry.f_254738_()).findFirst().orElse(null);
            AE2DataGenerators.addEntry(builder, entry, extension);
        }
        return CompletableFuture.completedFuture(builder.m_255144_(registryAccess));
    }

    private static <T> void addEntry(RegistrySetBuilder builder, RegistrySetBuilder.RegistryStub<T> entry, @Nullable LookupExtension<?> extension) {
        LookupExtension typedExtension;
        LookupExtension lookupExtension = typedExtension = extension != null ? extension.tryCast(entry.f_254738_()) : null;
        if (typedExtension == null) {
            builder.m_255162_(entry.f_254738_(), entry.f_254728_(), entry.f_254689_());
            return;
        }
        builder.m_255162_(entry.f_254738_(), entry.f_254728_(), bootstapContext -> {
            entry.f_254689_().m_254966_(bootstapContext);
            typedExtension.extender().accept(bootstapContext);
        });
    }

    record LookupExtension<T>(ResourceKey<Registry<T>> key, Consumer<BootstapContext<T>> extender) {
        @Nullable
        public <U> LookupExtension<U> tryCast(ResourceKey<? extends Registry<U>> registryKey) {
            if (Objects.equals(registryKey, this.key)) {
                return this;
            }
            return null;
        }
    }
}

