/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldGenProvider
implements DataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldGenProvider.class);
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public WorldGenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> m_213708_(CachedOutput writer) {
        return this.registries.thenComposeAsync(provider -> {
            RegistryOps dynamicOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
            CompletableFuture[] futures = (CompletableFuture[])RegistryDataLoader.f_243803_.stream().map(info -> this.writeRegistryEntries(writer, (HolderLookup.Provider)provider, (DynamicOps<JsonElement>)dynamicOps, (RegistryDataLoader.RegistryData)info)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures);
        });
    }

    private <T> CompletableFuture<Void> writeRegistryEntries(CachedOutput writer, HolderLookup.Provider provider, DynamicOps<JsonElement> ops, RegistryDataLoader.RegistryData<T> registryData) {
        ResourceKey registryKey = registryData.f_243794_();
        HolderLookup.RegistryLookup registry = provider.m_255025_(registryKey);
        PackOutput.PathProvider pathResolver = this.output.m_245269_(PackOutput.Target.DATA_PACK, registryKey.m_135782_().m_135815_());
        CompletableFuture[] futures = (CompletableFuture[])registry.m_214062_().flatMap(regEntry -> {
            ResourceKey key = regEntry.m_205785_();
            if (!key.m_135782_().m_135827_().equals("ae2")) {
                return Stream.empty();
            }
            Path path = pathResolver.m_245731_(key.m_135782_());
            return WorldGenProvider.writeToPath(path, writer, ops, registryData.f_244580_(), regEntry.m_203334_()).stream();
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private static <E> Optional<CompletableFuture<?>> writeToPath(Path path, CachedOutput cache, DynamicOps<JsonElement> json, Encoder<E> encoder, E value) {
        Optional optional = encoder.encodeStart(json, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        return optional.map(data -> DataProvider.m_253162_((CachedOutput)cache, (JsonElement)data, (Path)path));
    }

    public String m_6055_() {
        return "AE2 Worldgen";
    }
}

