/*
 * Decompiled with CFR 0.152.
 */
package appeng.decorative.solid;

import appeng.block.AEBaseBlock;
import appeng.core.definitions.AEBlocks;
import appeng.decorative.solid.CertusQuartzClusterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;

public class BuddingCertusQuartzBlock
extends AEBaseBlock {
    public static final int GROWTH_CHANCE = 5;
    public static final int DECAY_CHANCE = 12;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingCertusQuartzBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        AEBaseBlock newBlock;
        if (randomSource.m_188503_(5) != 0) {
            return;
        }
        Direction direction = DIRECTIONS[randomSource.m_188503_(DIRECTIONS.length)];
        BlockPos targetPos = pos.m_121945_(direction);
        BlockState targetState = level.m_8055_(targetPos);
        CertusQuartzClusterBlock newCluster = null;
        if (BuddingCertusQuartzBlock.canClusterGrowAtState(targetState)) {
            newCluster = AEBlocks.SMALL_QUARTZ_BUD.block();
        } else if (targetState.m_60713_((Block)AEBlocks.SMALL_QUARTZ_BUD.block()) && targetState.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
            newCluster = AEBlocks.MEDIUM_QUARTZ_BUD.block();
        } else if (targetState.m_60713_((Block)AEBlocks.MEDIUM_QUARTZ_BUD.block()) && targetState.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
            newCluster = AEBlocks.LARGE_QUARTZ_BUD.block();
        } else if (targetState.m_60713_((Block)AEBlocks.LARGE_QUARTZ_BUD.block()) && targetState.m_61143_((Property)AmethystClusterBlock.f_152006_) == direction) {
            newCluster = AEBlocks.QUARTZ_CLUSTER.block();
        }
        if (newCluster == null) {
            return;
        }
        BlockState newClusterState = (BlockState)((BlockState)newCluster.m_49966_().m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)direction)).m_61124_((Property)AmethystClusterBlock.f_152005_, (Comparable)Boolean.valueOf(targetState.m_60819_().m_76152_() == Fluids.f_76193_));
        level.m_46597_(targetPos, newClusterState);
        if (this == AEBlocks.FLAWLESS_BUDDING_QUARTZ.block() || randomSource.m_188503_(12) != 0) {
            return;
        }
        if (this == AEBlocks.FLAWED_BUDDING_QUARTZ.block()) {
            newBlock = AEBlocks.CHIPPED_BUDDING_QUARTZ.block();
        } else if (this == AEBlocks.CHIPPED_BUDDING_QUARTZ.block()) {
            newBlock = AEBlocks.DAMAGED_BUDDING_QUARTZ.block();
        } else if (this == AEBlocks.DAMAGED_BUDDING_QUARTZ.block()) {
            newBlock = AEBlocks.QUARTZ_BLOCK.block();
        } else {
            throw new IllegalStateException("Unexpected block: " + this);
        }
        level.m_46597_(pos, newBlock.m_49966_());
    }

    public static boolean canClusterGrowAtState(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76186_() == 8;
    }
}

