/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.blocks;

import appeng.api.client.AEStackRendering;
import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.InGameTooltip;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class PatternProviderDataProvider
implements BodyProvider<PatternProviderLogicHost>,
ServerDataProvider<PatternProviderLogicHost> {
    private static final String NBT_LOCK_REASON = "craftingLockReason";

    @Override
    public void buildTooltip(PatternProviderLogicHost host, TooltipContext context, TooltipBuilder tooltip) {
        String lockReason = context.serverData().m_128461_(NBT_LOCK_REASON);
        if (!lockReason.isEmpty()) {
            tooltip.addLine((Component)Component.Serializer.m_130701_((String)lockReason));
        }
    }

    @Override
    public void provideServerData(ServerPlayer player, PatternProviderLogicHost host, CompoundTag serverData) {
        PatternProviderLogic logic = host.getLogic();
        MutableComponent reason = null;
        switch (logic.getCraftingLockedReason()) {
            case LOCK_UNTIL_PULSE: {
                reason = InGameTooltip.CraftingLockedUntilPulse.text();
                break;
            }
            case LOCK_WHILE_HIGH: {
                reason = InGameTooltip.CraftingLockedByRedstoneSignal.text();
                break;
            }
            case LOCK_WHILE_LOW: {
                reason = InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
                break;
            }
            case LOCK_UNTIL_RESULT: {
                MutableComponent stackAmount;
                MutableComponent stackName;
                GenericStack stack = logic.getUnlockStack();
                if (stack != null) {
                    stackName = AEStackRendering.getDisplayName(stack.what());
                    stackAmount = Component.m_237113_((String)stack.what().formatAmount(stack.amount(), AmountFormat.FULL));
                } else {
                    stackName = Component.m_237113_((String)"ERROR");
                    stackAmount = Component.m_237113_((String)"ERROR");
                }
                reason = InGameTooltip.CraftingLockedUntilResult.text(stackName, stackAmount);
            }
        }
        if (reason != null) {
            serverData.m_128359_(NBT_LOCK_REASON, Component.Serializer.m_130703_((Component)reason.m_6881_().m_130940_(ChatFormatting.RED)));
        }
    }
}

