/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.interaction;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.menu.me.interaction.ContainerItemContext;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.FluidContainerItemStrategy;
import appeng.util.CowMap;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class StackInteractions {
    private static final CowMap<AEKeyType, ContainerItemStrategy<?, ?>> strategies = CowMap.identityHashMap();

    public static <T extends AEKey> void register(AEKeyType type, Class<T> keyClass, ContainerItemStrategy<T, ?> strategy) {
        Preconditions.checkArgument((type.getKeyClass() == keyClass ? 1 : 0) != 0, (String)"%s != %s", type.getKeyClass(), keyClass);
        Preconditions.checkArgument((type != AEKeyType.items() ? 1 : 0) != 0, (Object)"Can't register container items for AEItemKey");
        strategies.putIfAbsent(type, strategy);
    }

    public static boolean isTypeSupported(AEKeyType type) {
        return strategies.getMap().containsKey(type);
    }

    public static boolean isKeySupported(@Nullable AEKey key) {
        return key != null && StackInteractions.isTypeSupported(key.getType());
    }

    @Nullable
    public static GenericStack getContainedStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Map.Entry<AEKeyType, ContainerItemStrategy<?, ?>> entry : strategies.getMap().entrySet()) {
            GenericStack content = entry.getValue().getContainedStack(stack);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    @Nullable
    public static GenericStack getContainedStack(ItemStack stack, AEKeyType keyType) {
        if (stack.m_41619_()) {
            return null;
        }
        ContainerItemStrategy<?, ?> strategy = strategies.getMap().get(keyType);
        if (strategy != null) {
            return strategy.getContainedStack(stack);
        }
        return null;
    }

    @Nullable
    public static EmptyingAction getEmptyingAction(ItemStack stack) {
        GenericStack contents = StackInteractions.getContainedStack(stack);
        if (contents == null) {
            return null;
        }
        Component description = contents.what().getDisplayName();
        return new EmptyingAction(description, contents.what(), contents.amount());
    }

    public static ContainerItemContext findCarriedContextForKey(@Nullable AEKey key, Player player, AbstractContainerMenu menu) {
        return StackInteractions.findCarriedContext(key == null ? null : key.getType(), player, menu);
    }

    @Nullable
    public static ContainerItemContext findCarriedContext(@Nullable AEKeyType keyType, Player player, AbstractContainerMenu menu) {
        Collection<AEKeyType> candidates = keyType == null ? strategies.getMap().keySet() : List.of(keyType);
        for (AEKeyType type : candidates) {
            Object context;
            ContainerItemStrategy<AEKey, Object> strategy = strategies.getMap().get(type);
            if (strategy == null || (context = strategy.findCarriedContext(player, menu)) == null) continue;
            return new ContainerItemContext(strategy, context, type);
        }
        return null;
    }

    public static Set<AEKeyType> getSupportedKeyTypes() {
        return strategies.getMap().keySet();
    }

    @Nullable
    public static ContainerItemContext findOwnedItemContext(@Nullable AEKeyType keyType, Player player, ItemStack stack) {
        if (player.f_36096_ != null && player.f_36096_.m_142621_() == stack) {
            return StackInteractions.findCarriedContext(keyType, player, player.f_36096_);
        }
        int slotIdx = -1;
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i) != stack) continue;
            slotIdx = i;
            break;
        }
        if (slotIdx == -1) {
            return null;
        }
        Collection<AEKeyType> candidates = keyType == null ? strategies.getMap().keySet() : List.of(keyType);
        for (AEKeyType type : candidates) {
            Object context;
            ContainerItemStrategy<AEKey, Object> strategy = strategies.getMap().get(type);
            if (strategy == null || (context = strategy.findPlayerSlotContext(player, slotIdx)) == null) continue;
            return new ContainerItemContext(strategy, context, type);
        }
        return null;
    }

    static {
        StackInteractions.register(AEKeyType.fluids(), AEFluidKey.class, new FluidContainerItemStrategy());
    }
}

