/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class InscriberRecipeBuilder {
    private final Ingredient middleInput;
    private Ingredient topOptional;
    private Ingredient bottomOptional;
    private final ItemLike output;
    private final int count;
    private InscriberProcessType mode = InscriberProcessType.INSCRIBE;

    public InscriberRecipeBuilder(Ingredient middleInput, ItemLike output, int count) {
        this.middleInput = middleInput;
        this.output = output;
        this.count = count;
    }

    public static InscriberRecipeBuilder inscribe(ItemLike middle, ItemLike output, int count) {
        return new InscriberRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{middle}), output, count);
    }

    public static InscriberRecipeBuilder inscribe(TagKey<Item> middle, ItemLike output, int count) {
        return new InscriberRecipeBuilder(Ingredient.m_204132_(middle), output, count);
    }

    public static InscriberRecipeBuilder inscribe(Ingredient middle, ItemLike output, int count) {
        return new InscriberRecipeBuilder(middle, output, count);
    }

    public InscriberRecipeBuilder setTop(Ingredient topOptional) {
        this.topOptional = topOptional;
        return this;
    }

    public InscriberRecipeBuilder setBottom(Ingredient bottomOptional) {
        this.bottomOptional = bottomOptional;
        return this;
    }

    public InscriberRecipeBuilder setMode(InscriberProcessType processType) {
        this.mode = processType;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id));
    }

    class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("mode", InscriberRecipeBuilder.this.mode.name().toLowerCase(Locale.ROOT));
            JsonObject result = new JsonObject();
            result.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)InscriberRecipeBuilder.this.output.m_5456_()).toString());
            if (InscriberRecipeBuilder.this.count > 1) {
                result.addProperty("count", (Number)InscriberRecipeBuilder.this.count);
            }
            json.add("result", (JsonElement)result);
            JsonObject ingredients = new JsonObject();
            ingredients.add("middle", InscriberRecipeBuilder.this.middleInput.m_43942_());
            if (InscriberRecipeBuilder.this.topOptional != null) {
                ingredients.add("top", InscriberRecipeBuilder.this.topOptional.m_43942_());
            }
            if (InscriberRecipeBuilder.this.bottomOptional != null) {
                ingredients.add("bottom", InscriberRecipeBuilder.this.bottomOptional.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return InscriberRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

