/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class TransformCircumstance {
    public static final TransformCircumstance EXPLOSION = new TransformCircumstance("explosion");
    private final String type;

    public TransformCircumstance(String type) {
        this.type = type;
    }

    static TransformCircumstance fromJson(JsonObject obj) {
        String type = obj.get("type").getAsString();
        if (type.equals("explosion")) {
            return TransformCircumstance.explosion();
        }
        if (type.equals("fluid")) {
            return TransformCircumstance.fluid((TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(obj.get("tag").getAsString())));
        }
        throw new JsonParseException("Invalid transform recipe type " + type);
    }

    static TransformCircumstance fromNetwork(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        if (type.equals("explosion")) {
            return TransformCircumstance.explosion();
        }
        if (type.equals("fluid")) {
            return TransformCircumstance.fluid((TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)buf.m_130281_()));
        }
        throw new DecoderException("Invalid transform recipe type " + type);
    }

    public static TransformCircumstance fluid(TagKey<Fluid> tag) {
        return new FluidType(tag);
    }

    public static TransformCircumstance explosion() {
        return EXPLOSION;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.type);
        return obj;
    }

    void toNetwork(FriendlyByteBuf buf) {
        buf.m_130070_(this.type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TransformCircumstance)) return false;
        TransformCircumstance other = (TransformCircumstance)obj;
        if (!this.type.equals(other.type)) return false;
        return true;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean isExplosion() {
        return this.type.equals("explosion");
    }

    public boolean isFluid() {
        return false;
    }

    public boolean isFluid(FluidState state) {
        return false;
    }

    public boolean isFluid(Fluid fluid) {
        return false;
    }

    public List<Fluid> getFluidsForRendering() {
        return List.of();
    }

    private static class FluidType
    extends TransformCircumstance {
        public final TagKey<Fluid> fluidTag;

        public FluidType(TagKey<Fluid> fluidTag) {
            super("fluid");
            this.fluidTag = fluidTag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FluidType)) return false;
            FluidType other = (FluidType)obj;
            if (!Objects.equals(this.fluidTag, other.fluidTag)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.fluidTag);
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = super.toJson();
            obj.addProperty("tag", this.fluidTag.f_203868_().toString());
            return obj;
        }

        @Override
        void toNetwork(FriendlyByteBuf buf) {
            super.toNetwork(buf);
            buf.m_130085_(this.fluidTag.f_203868_());
        }

        @Override
        public boolean isFluid() {
            return true;
        }

        @Override
        public boolean isFluid(Fluid fluid) {
            return fluid.m_205067_(this.fluidTag);
        }

        @Override
        public boolean isFluid(FluidState state) {
            return state.m_205070_(this.fluidTag);
        }

        @Override
        public List<Fluid> getFluidsForRendering() {
            return BuiltInRegistries.f_257020_.m_203431_(this.fluidTag).map(t -> t.m_203614_().map(Holder::m_203334_).toList()).orElse(List.of());
        }
    }
}

