/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.core.AppEng;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MeteoriteStructure
extends Structure {
    public static final ResourceLocation ID = AppEng.makeId("meteorite");
    public static final ResourceKey<StructureSet> STRUCTURE_SET_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)ID);
    public static final Codec<MeteoriteStructure> CODEC = MeteoriteStructure.m_226607_(MeteoriteStructure::new);
    public static final ResourceKey<Structure> KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)ID);
    public static final TagKey<Biome> BIOME_TAG_KEY = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)AppEng.makeId("has_meteorites"));
    public static StructureType<MeteoriteStructure> TYPE;

    public MeteoriteStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public StructureType<?> m_213658_() {
        return TYPE;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        if (!worldgenRandom.m_188499_()) {
            return Optional.empty();
        }
        return MeteoriteStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, structurePiecesBuilder -> MeteoriteStructure.generatePieces(structurePiecesBuilder, context));
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        ChunkGenerator generator = context.f_226622_();
        int centerX = chunkPos.m_45604_() + random.m_188503_(16);
        int centerZ = chunkPos.m_45605_() + random.m_188503_(16);
        float meteoriteRadius = random.m_188501_() * 6.0f + 2.0f;
        int yOffset = (int)Math.ceil(meteoriteRadius) + 1;
        Set t2 = generator.m_62218_().m_183399_(centerX, generator.m_6337_(), centerZ, 0, context.f_226624_().m_224579_());
        Holder spawnBiome = (Holder)t2.stream().findFirst().orElseThrow();
        boolean isOcean = spawnBiome.m_203656_(ConventionTags.METEORITE_OCEAN);
        Heightmap.Types heightmapType = isOcean ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        StatsAccumulator stats = new StatsAccumulator();
        int scanRadius = (int)Math.max(1.0f, meteoriteRadius * 2.0f);
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                int h = generator.m_214096_(centerX + x, centerZ + z, heightmapType, heightAccessor, context.f_226624_());
                stats.add((double)h);
            }
        }
        int centerY = (int)stats.mean();
        if (stats.populationVariance() > 5.0) {
            centerY = (int)((double)centerY - (stats.mean() - stats.min()) * 0.75);
        }
        centerY -= yOffset;
        centerY = Math.max(heightAccessor.m_141937_() + yOffset, centerY);
        BlockPos actualPos = new BlockPos(centerX, centerY, centerZ);
        boolean craterLake = MeteoriteStructure.locateWaterAroundTheCrater(actualPos, meteoriteRadius, context);
        CraterType craterType = MeteoriteStructure.determineCraterType((Holder<Biome>)spawnBiome, random);
        boolean pureCrater = random.m_188501_() > 0.9f;
        FalloutMode fallout = FalloutMode.fromBiome((Holder<Biome>)spawnBiome);
        piecesBuilder.m_142679_((StructurePiece)new MeteoriteStructurePiece(actualPos, meteoriteRadius, craterType, fallout, pureCrater, craterLake));
    }

    private static boolean locateWaterAroundTheCrater(BlockPos pos, float radius, Structure.GenerationContext context) {
        ChunkGenerator generator = context.f_226622_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        int seaLevel = generator.m_6337_();
        int maxY = seaLevel - 1;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        blockPos.m_142448_(maxY);
        for (int i = pos.m_123341_() - 32; i <= pos.m_123341_() + 32; ++i) {
            blockPos.m_142451_(i);
            for (int k = pos.m_123343_() - 32; k <= pos.m_123343_() + 32; ++k) {
                int heigth;
                blockPos.m_142443_(k);
                double dx = i - pos.m_123341_();
                double dz = k - pos.m_123343_();
                double h = (float)pos.m_123342_() - radius + 1.0f;
                double distanceFrom = dx * dx + dz * dz;
                if (!((double)maxY > h + distanceFrom * 0.0175) || !((double)maxY < h + distanceFrom * 0.02) || (heigth = generator.m_214096_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR, heightAccessor, context.f_226624_())) >= seaLevel) continue;
                return true;
            }
        }
        return false;
    }

    private static CraterType determineCraterType(Holder<Biome> biomeHolder, WorldgenRandom random) {
        boolean lava;
        boolean lake;
        boolean specialMeteor;
        Biome biome = (Biome)biomeHolder.m_203334_();
        float temp = biome.m_47554_();
        if (biomeHolder.m_203656_(ConventionTags.METEORITE_OCEAN)) {
            return CraterType.NONE;
        }
        boolean bl = specialMeteor = random.m_188501_() > 0.5f;
        if (!specialMeteor) {
            return CraterType.NORMAL;
        }
        if (temp >= 1.0f) {
            boolean lava2 = random.m_188501_() > 0.5f;
            switch (biome.m_47530_()) {
                case NONE: {
                    return lava2 ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    boolean obsidian = random.m_188501_() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    return lava2 ? alternativObsidian : CraterType.NORMAL;
                }
            }
        }
        if (temp < 1.0f && (double)temp >= 0.2) {
            lake = random.m_188501_() > 0.25f;
            lava = random.m_188501_() > 0.8f;
            switch (biome.m_47530_()) {
                case NONE: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    boolean obsidian = random.m_188501_() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    CraterType craterLake = lake ? CraterType.WATER : CraterType.NORMAL;
                    return lava ? alternativObsidian : craterLake;
                }
                case SNOW: {
                    boolean snow = random.m_188501_() > 0.75f;
                    CraterType water = lake ? CraterType.WATER : CraterType.NORMAL;
                    return snow ? CraterType.SNOW : water;
                }
            }
        }
        if ((double)temp < 0.2) {
            lake = random.m_188501_() > 0.25f;
            lava = random.m_188501_() > 0.95f;
            boolean frozen = random.m_188501_() > 0.25f;
            switch (biome.m_47530_()) {
                case NONE: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    CraterType frozenLake = frozen ? CraterType.ICE : CraterType.WATER;
                    CraterType craterLake = lake ? frozenLake : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : craterLake;
                }
                case SNOW: {
                    CraterType snowCovered = lake ? CraterType.SNOW : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : snowCovered;
                }
            }
        }
        return CraterType.NORMAL;
    }
}

