/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.GrowingBeanstalkBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.EffectRenders;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.block.doors.CastleDoorModelLoader;
import twilightforest.client.model.block.giantblock.GiantBlockModelLoader;
import twilightforest.client.model.block.leaves.BakedLeavesModel;
import twilightforest.client.model.block.patch.PatchModelLoader;
import twilightforest.client.renderer.TFSkyRenderer;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.events.HostileMountEvents;
import twilightforest.init.TFItems;
import twilightforest.item.EnderBowItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;
import twilightforest.world.registration.TFGenerationSettings;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT})
public class TFClientEvents {
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;
    private static float intensity = 0.0f;
    private static final MutableComponent WIP_TEXT_0 = Component.m_237115_((String)"twilightforest.misc.wip0").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final MutableComponent WIP_TEXT_1 = Component.m_237115_((String)"twilightforest.misc.wip1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final MutableComponent NYI_TEXT = Component.m_237115_((String)"twilightforest.misc.nyi").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));

    @SubscribeEvent
    public static void preOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id() == VanillaGuiOverlay.MOUNT_HEALTH.id() && HostileMountEvents.isRidingUnfriendly((LivingEntity)Minecraft.m_91087_().f_91074_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            EntityRenderer renderer;
            if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
                return;
            }
            Options settings = Minecraft.m_91087_().f_91066_;
            if (settings.m_92176_() != CameraType.FIRST_PERSON || settings.f_92062_) {
                return;
            }
            Entity entity = Minecraft.m_91087_().m_91288_();
            if (entity instanceof LivingEntity && (renderer = Minecraft.m_91087_().m_91290_().m_114382_(entity)) instanceof LivingEntityRenderer) {
                for (EffectRenders effect : EffectRenders.VALUES) {
                    if (!effect.shouldRender((LivingEntity)entity, true)) continue;
                    effect.render((LivingEntity)entity, (EntityModel<? extends LivingEntity>)((LivingEntityRenderer)renderer).m_7200_(), 0.0, 0.0, 0.0, event.getPartialTick(), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && TFGenerationSettings.DIMENSION_KEY.equals((Object)minecraft.f_91073_.m_46472_()) && minecraft.f_91065_ != null) {
                minecraft.f_91065_.f_92980_ = 0.0f;
            }
            if (minecraft.f_91074_ != null && HostileMountEvents.isRidingUnfriendly((LivingEntity)minecraft.f_91074_) && minecraft.f_91065_ != null) {
                minecraft.f_91065_.m_93063_((Component)Component.m_237119_(), false);
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float partial = mc.m_91296_();
        if (!mc.m_91104_() || mc.f_91080_ != null && mc.f_91080_.getClass().equals(AdvancementsScreen.class)) {
            ++time;
            rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
            sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
            rotationTicker = (float)rotationTickerI + partial;
            sineTicker += partial;
        }
        if (!mc.m_91104_()) {
            BugModelAnimationHelper.animate();
            DimensionSpecialEffects info = DimensionSpecialEffectsManager.getForType((ResourceLocation)TwilightForestMod.prefix("renderer"));
            if (mc.f_91073_ != null && info instanceof TwilightForestRenderInfo) {
                TFWeatherRenderer.tick();
            }
            if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && mc.f_91073_ != null && mc.f_91074_ != null) {
                HashSet<ChunkPos> chunksInRange = new HashSet<ChunkPos>();
                for (int x = -16; x <= 16; x += 16) {
                    for (int z = -16; z <= 16; z += 16) {
                        chunksInRange.add(new ChunkPos((int)(mc.f_91074_.m_20185_() + (double)x) >> 4, (int)(mc.f_91074_.m_20189_() + (double)z) >> 4));
                    }
                }
                for (ChunkPos pos : chunksInRange) {
                    List beanstalksInChunk;
                    if (mc.f_91073_.m_6522_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62326_, false) == null || (beanstalksInChunk = mc.f_91073_.m_6325_(pos.f_45578_, pos.f_45579_).m_62954_().values().stream().filter(blockEntity -> {
                        GrowingBeanstalkBlockEntity beanstalkBlock;
                        return blockEntity instanceof GrowingBeanstalkBlockEntity && (beanstalkBlock = (GrowingBeanstalkBlockEntity)((Object)blockEntity)).isBeanstalkRumbling();
                    }).collect(Collectors.toList())).isEmpty()) continue;
                    BlockEntity beanstalk = (BlockEntity)beanstalksInChunk.get(0);
                    LocalPlayer player = mc.f_91074_;
                    intensity = (float)(1.0 - mc.f_91074_.m_20238_(Vec3.m_82512_((Vec3i)beanstalk.m_58899_())) / Math.pow(16.0, 2.0));
                    if (!(intensity > 0.0f)) continue;
                    player.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity, player.m_146909_() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity);
                    intensity = 0.0f;
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public static void camera(ViewportEvent.ComputeCameraAngles event) {
        if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && !Minecraft.m_91087_().m_91104_() && intensity > 0.0f && Minecraft.m_91087_().f_91074_ != null) {
            event.setYaw((float)Mth.m_14139_((double)event.getPartialTick(), (double)event.getYaw(), (double)(event.getYaw() + (Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
            event.setPitch((float)Mth.m_14139_((double)event.getPartialTick(), (double)event.getPitch(), (double)(event.getPitch() + (Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
            event.setRoll((float)Mth.m_14139_((double)event.getPartialTick(), (double)event.getRoll(), (double)(event.getRoll() + (Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
            intensity = 0.0f;
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        if (!item.m_204117_(ItemTagGenerator.WIP) && !item.m_204117_(ItemTagGenerator.NYI)) {
            return;
        }
        if (item.m_204117_(ItemTagGenerator.WIP)) {
            event.getToolTip().add(WIP_TEXT_0);
            event.getToolTip().add(WIP_TEXT_1);
        } else {
            event.getToolTip().add(NYI_TEXT);
        }
    }

    @SubscribeEvent
    public static void FOVUpdate(ComputeFovModifierEvent event) {
        Item useItem;
        Player player = event.getPlayer();
        if (player.m_6117_() && ((useItem = player.m_21211_().m_41720_()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = (float)player.m_21252_() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            event.setNewFovModifier(event.getFovModifier() * (1.0f - f * 0.15f));
        }
    }

    @SubscribeEvent
    public static void unrenderHeadWithTrophies(RenderLivingEvent<?, ?> event) {
        EntityModel entityModel;
        boolean visible;
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
        boolean bl = visible = !(stack.m_41720_() instanceof TrophyItem) && !(stack.m_41720_() instanceof SkullCandleItem) && !TFClientEvents.areCuriosEquipped(event.getEntity());
        if (!visible && (entityModel = event.getRenderer().m_7200_()) instanceof HeadedModel) {
            HeadedModel headedModel = (HeadedModel)entityModel;
            headedModel.m_5585_().f_104207_ = false;
            EntityModel entityModel2 = event.getRenderer().m_7200_();
            if (entityModel2 instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)entityModel2;
                humanoidModel.f_102809_.f_104207_ = false;
            }
        }
    }

    private static boolean areCuriosEquipped(LivingEntity entity) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.isTrophyCurioEquipped(entity) || CuriosCompat.isSkullCurioEquipped(entity);
        }
        return false;
    }

    @SubscribeEvent
    public static void translateBookAuthor(ItemTooltipEvent event) {
        CompoundTag tag;
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof WrittenBookItem && stack.m_41782_() && (tag = stack.m_41784_()).m_128441_("twilightforest:book")) {
            List components = event.getToolTip();
            for (Component component : components) {
                if (!component.toString().contains("book.byAuthor")) continue;
                components.set(components.indexOf(component), Component.m_237115_((String)"book.byAuthor").m_7220_((Component)Component.m_237115_((String)"twilightforest.book.author")).m_130948_(component.m_7383_()));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register("patch", (IGeometryLoader)PatchModelLoader.INSTANCE);
            event.register("giant_block", (IGeometryLoader)GiantBlockModelLoader.INSTANCE);
            event.register("castle_door", (IGeometryLoader)CastleDoorModelLoader.INSTANCE);
        }

        @SubscribeEvent
        public static void modelBake(ModelEvent.ModifyBakingResult event) {
            TFItems.addItemModelProperties();
            List<Map.Entry> models = event.getModels().entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals("twilightforest") && ((ResourceLocation)entry.getKey()).m_135815_().contains("leaves") && !((ResourceLocation)entry.getKey()).m_135815_().contains("dark")).collect(Collectors.toList());
            models.forEach(entry -> event.getModels().put((ResourceLocation)entry.getKey(), new BakedLeavesModel((BakedModel)entry.getValue())));
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            event.register((ResourceLocation)ShieldLayer.LOC);
            event.register((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy"), "inventory"));
            event.register((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_minor"), "inventory"));
            event.register((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_quest"), "inventory"));
            event.register(TwilightForestMod.prefix("block/casket_obsidian"));
            event.register(TwilightForestMod.prefix("block/casket_stone"));
            event.register(TwilightForestMod.prefix("block/casket_basalt"));
        }

        @SubscribeEvent
        public static void registerDimEffects(RegisterDimensionSpecialEffectsEvent event) {
            new TFSkyRenderer();
            new TFWeatherRenderer();
            event.register(TwilightForestMod.prefix("renderer"), (DimensionSpecialEffects)new TwilightForestRenderInfo(128.0f, false, DimensionSpecialEffects.SkyType.NONE, false, false));
        }
    }
}

