/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleTileEntityRenderer<T extends SkullCandleBlockEntity>
implements BlockEntityRenderer<T> {
    private final Map<SkullBlock.Type, SkullModelBase> modelByType;
    public static final Map<SkullBlock.Type, ResourceLocation> SKIN_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_112552_ -> {
        p_112552_.put(SkullBlock.Types.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        p_112552_.put(SkullBlock.Types.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
        p_112552_.put(SkullBlock.Types.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
        p_112552_.put(SkullBlock.Types.CREEPER, new ResourceLocation("textures/entity/creeper/creeper.png"));
        p_112552_.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.m_118626_());
    });

    public static Map<SkullBlock.Type, SkullModelBase> createSkullRenderers(EntityModelSet p_173662_) {
        ImmutableMap.Builder var1 = ImmutableMap.builder();
        var1.put((Object)SkullBlock.Types.SKELETON, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171240_)));
        var1.put((Object)SkullBlock.Types.WITHER_SKELETON, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171219_)));
        var1.put((Object)SkullBlock.Types.PLAYER, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171163_)));
        var1.put((Object)SkullBlock.Types.ZOMBIE, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171224_)));
        var1.put((Object)SkullBlock.Types.CREEPER, (Object)new SkullModel(p_173662_.m_171103_(ModelLayers.f_171130_)));
        return var1.build();
    }

    public SkullCandleTileEntityRenderer(BlockEntityRendererProvider.Context renderer) {
        this.modelByType = SkullCandleTileEntityRenderer.createSkullRenderers(renderer.m_173585_());
    }

    public void render(SkullCandleBlockEntity tile, float ticks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = tile.m_58900_();
        boolean flag = state.m_60734_() instanceof WallSkullCandleBlock;
        Direction dir = flag ? (Direction)state.m_61143_((Property)WallSkullCandleBlock.FACING) : null;
        float offset = 22.5f * (float)(flag ? (2 + dir.m_122416_()) * 4 : (Integer)state.m_61143_((Property)SkullCandleBlock.ROTATION));
        SkullBlock.Type type = ((AbstractSkullCandleBlock)state.m_60734_()).getType();
        SkullModelBase base = this.modelByType.get(type);
        RenderType render = SkullCandleTileEntityRenderer.getRenderType(type, tile.m_59779_());
        SkullCandleTileEntityRenderer.renderSkull(dir, offset, 0.0f, ms, buffer, light, base, render);
        if (dir != null) {
            ms.m_85837_((double)(-((float)dir.m_122429_()) * 0.25f), 0.0, (double)(-((float)dir.m_122431_()) * 0.25f));
        }
        ms.m_252880_(0.0f, flag ? 0.75f : 0.45f, 0.0f);
        if (tile.candleAmount <= 0) {
            tile.candleAmount = 1;
        }
        Minecraft.m_91087_().m_91289_().m_110912_((BlockState)((BlockState)AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(tile.candleColor).m_7912_()).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(tile.candleAmount))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(state.m_61143_((Property)AbstractSkullCandleBlock.LIGHTING) == AbstractLightableBlock.Lighting.NORMAL)), ms, buffer, light, overlay);
    }

    public static void renderSkull(@Nullable Direction dir, float ticks, float animTime, PoseStack ms, MultiBufferSource buffer, int light, SkullModelBase base, RenderType render) {
        ms.m_85836_();
        if (dir == null) {
            ms.m_85837_(0.5, 0.0, 0.5);
        } else {
            ms.m_85837_((double)(0.5f - (float)dir.m_122429_() * 0.25f), 0.25, (double)(0.5f - (float)dir.m_122431_() * 0.25f));
        }
        ms.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer consumer = buffer.m_6299_(render);
        base.m_6251_(animTime, ticks, 0.0f);
        base.m_7695_(ms, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ms.m_85849_();
    }

    public static RenderType getRenderType(SkullBlock.Type pSkullType, @Nullable GameProfile pGameProfile) {
        ResourceLocation resourcelocation = SKIN_BY_TYPE.get(pSkullType);
        if (pSkullType == SkullBlock.Types.PLAYER && pGameProfile != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(pGameProfile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_((ResourceLocation)minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)pGameProfile)));
        }
        return RenderType.m_110464_((ResourceLocation)resourcelocation);
    }
}

