/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.renderers;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import twilightforest.TwilightForestMod;

public class EntityRenderer
implements IIngredientRenderer<EntityType> {
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();
    private final int size;
    private final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();

    public EntityRenderer(int size) {
        this.size = size;
    }

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }

    public void render(PoseStack stack, @Nullable EntityType type) {
        ClientLevel level;
        if (type != null && (level = Minecraft.m_91087_().f_91073_) != null && !IGNORED_ENTITIES.contains(type)) {
            Object entity = type == EntityType.f_20532_ ? Minecraft.m_91087_().f_91074_ : this.ENTITY_MAP.computeIfAbsent(type, arg_0 -> EntityRenderer.lambda$render$0((Level)level, arg_0));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int scale = this.size / 2;
                float height = entity.m_20206_();
                float width = entity.m_20205_();
                if (height > 2.25f || width > 2.25f) {
                    scale = (int)(20.0f / Math.max(height, width));
                }
                try {
                    PoseStack modelView = RenderSystem.m_157191_();
                    modelView.m_85836_();
                    modelView.m_252931_(stack.m_85850_().m_252922_());
                    this.renderTheEntity(this.size / 2, this.size - 2, scale, livingEntity);
                    modelView.m_85849_();
                    RenderSystem.m_157182_();
                }
                catch (Exception e) {
                    TwilightForestMod.LOGGER.error("Error drawing entity " + ForgeRegistries.ENTITY_TYPES.getKey((Object)type), (Throwable)e);
                    IGNORED_ENTITIES.add(type);
                    this.ENTITY_MAP.remove(type);
                }
            } else {
                IGNORED_ENTITIES.add(type);
                this.ENTITY_MAP.remove(type);
            }
        }
    }

    public List<Component> getTooltip(EntityType type, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(type.m_20676_());
        if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    private void renderTheEntity(int x, int y, int scale, LivingEntity entity) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 1050.0);
        if (entity.m_6095_() == EntityType.f_20453_) {
            posestack.m_85837_(0.0, -8.5, 0.0);
        }
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion1 = Axis.f_252529_.m_252977_(20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        posestack1.m_252781_(quaternion);
        posestack1.m_252781_(Axis.f_252495_.m_252977_(35.0f));
        posestack1.m_252781_(Axis.f_252392_.m_252977_(145.0f));
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 0.0f;
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.conjugate();
        entityrenderdispatcher.m_252923_(quaternion1);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private static /* synthetic */ Entity lambda$render$0(Level level, EntityType t) {
        return t.m_20615_(level);
    }
}

